/* about.c */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <glib.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtkwindow.h>
#include <gtk/gtksignal.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkpixmap.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkhseparator.h>
#include <gtk/gtkscrolledwindow.h>
#include <gtk/gtktext.h>
#include <gtk/gtkbutton.h>
#include <sys/utsname.h>

#include "intl.h"
#include "about.h"
#include "gtkutils.h"

#include "pixmaps/sylpheed-logo.xpm"

static GtkWidget *window;

static void about_create(void);
static void key_pressed(GtkWidget *widget, GdkEventKey *event);

void about_show(void)
{
	if (!window)
		about_create();
	else
		gtk_widget_show(window);
}

static void about_create(void)
{
	GtkWidget *vbox;
	GdkPixmap *logoxpm = NULL;
	GdkBitmap *logoxpmmask;
	GtkWidget *pixmap;
	GtkWidget *label;
	GtkWidget *scrolledwin;
	GtkWidget *text;
	GtkWidget *confirm_area;
	GtkWidget *ok_button;

	struct utsname utsbuf;
	gchar buf[1024];

	window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(window), _("About"));
	gtk_container_set_border_width(GTK_CONTAINER(window), 8);
	gtk_widget_set_usize(window, 518, 350);
	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
	//gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
	gtk_signal_connect(GTK_OBJECT(window), "delete_event",
			   GTK_SIGNAL_FUNC(gtk_widget_hide_on_delete), NULL);
	gtk_signal_connect(GTK_OBJECT(window), "key_press_event",
			   GTK_SIGNAL_FUNC(key_pressed), NULL);
	gtk_widget_realize(window);

	vbox = gtk_vbox_new(FALSE, 8);
	gtk_container_add(GTK_CONTAINER(window), vbox);

	PIXMAP_CREATE(window, logoxpm, logoxpmmask, sylpheed_logo_xpm);
	pixmap = gtk_pixmap_new(logoxpm, logoxpmmask);
	gtk_box_pack_start(GTK_BOX(vbox), pixmap, FALSE, FALSE, 0);

	label = gtk_label_new("version "VERSION);
	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

	uname(&utsbuf);
	g_snprintf(buf, sizeof(buf),
		   "GTK+ version %d.%d.%d\n"
		   "Operating System: %s %s (%s)",
		   gtk_major_version, gtk_minor_version, gtk_micro_version,
		   utsbuf.sysname, utsbuf.release, utsbuf.machine);

	label = gtk_label_new(buf);
	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

	label = gtk_label_new
		("Copyright (C) 1999,2000 Hiroyuki Yamamoto <hiro-y@kcn.ne.jp>");
	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

	scrolledwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwin),
				       GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
	gtk_box_pack_start(GTK_BOX(vbox), scrolledwin, TRUE, TRUE, 0);

	text = gtk_text_new(gtk_scrolled_window_get_hadjustment
			    (GTK_SCROLLED_WINDOW(scrolledwin)),
			    gtk_scrolled_window_get_vadjustment
			    (GTK_SCROLLED_WINDOW(scrolledwin)));
	gtk_container_add(GTK_CONTAINER(scrolledwin), text);

	gtk_text_freeze(GTK_TEXT(text));

	gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL,
		_("The portions applied from fetchmail is Copyright 1997 by Eric S. Raymond.\n"
		  "Portions of those are also copyrighted by Carl Harris, 1993 and 1995.\n"
		  "Copyright retained for the purpose of protecting free redistribution of\n"
		  "source.\n\n"), -1);

	gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL,
		_("The MD5 support is copyright by RSA Data Security, Inc.  See the header\n"
		  "comment of the md5.c module for license terms.\n\n"), -1);

	gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL,
		_("Kcc is copyright by Yasuhiro Tonooka <tonooka@msi.co.jp>,\n"
		  "and libkcc is copyright by takeshi@SoftAgency.co.jp.\n\n"), -1);

	gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL,
		_("This program is free software; you can redistribute it and/or modify\n"
		  "it under the terms of the GNU General Public License as published by\n"
		  "the Free Software Foundation; either version 2, or (at your option)\n"
		  "any later version.\n\n"), -1);

	gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL,
		_("This program is distributed in the hope that it will be useful,\n"
		  "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		  "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n"
		  "See the GNU General Public License for more details.\n\n"), -1);

	gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL,
		_("You should have received a copy of the GNU General Public License\n"
		  "along with this program; if not, write to the Free Software\n"
		  "Foundation, Inc., 59 Temple Place - Suite 330, Boston,\n"
		  "MA 02111-1307, USA."), -1);

	gtk_text_thaw(GTK_TEXT(text));

	gtkut_button_set_create(&confirm_area, &ok_button, _("OK"),
				NULL, NULL, NULL, NULL);
	gtk_box_pack_end(GTK_BOX(vbox), confirm_area, FALSE, FALSE, 0);
	gtk_widget_grab_default(ok_button);
	gtk_signal_connect_object(GTK_OBJECT(ok_button), "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_hide_on_delete),
				  GTK_OBJECT(window));

	gtk_widget_show_all(window);
}

static void key_pressed(GtkWidget *widget, GdkEventKey *event)
{
	if (event && event->keyval == GDK_Escape)
		gtk_widget_hide(window);
}
