#ifndef __COMPOSE_H__
#define __COMPOSE_H__

#include <glib.h>

#include "procmsg.h"

typedef struct _Compose	Compose;

typedef enum
{
	COMPOSE_MAIL,
	COMPOSE_NEWS
} ComposeMode;

struct _Compose
{
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *menubar;

	GtkWidget *handlebox;
	GtkWidget *toolbar;
	GtkWidget *send_btn;
	GtkWidget *insert_btn;
	GtkWidget *sig_btn;
	GtkWidget *addrbook_btn;

	GtkWidget *table_vbox;
	GtkWidget *table;
	GtkWidget *to_entry;
	GtkWidget *subject_entry;
	GtkWidget *cc_entry;
	GtkWidget *bcc_hbox;
	GtkWidget *bcc_entry;

	GtkWidget *scrolledwin;
	GtkWidget *text;

	gchar   *replyto;
	gchar   *cc;
	gchar   *inreplyto;
	gchar   *references;

	gboolean use_bcc;

	GSList  *to_list;
};

void compose_new	(void);
void compose_reply	(MsgInfo *msginfo);
void compose_quote	(MsgInfo *msginfo);
void compose_forward	(MsgInfo *msginfo);

#endif /* __COMPOSE_H__ */
