/* filesel.c */

#include <glib.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtkfilesel.h>
#include <gtk/gtkmain.h>
#include <gtk/gtksignal.h>

#include "filesel.h"

static GtkWidget *filesel;
static gboolean filesel_ack;

static void filesel_create(const gchar *title);
static void filesel_ok_cb(GtkWidget *widget, gpointer data);
static void filesel_cancel_cb(GtkWidget *widget, gpointer data);

gchar *filesel_select_file(const gchar *title)
{
	static gchar *filename;

	g_free(filename);
	filename = NULL;

	filesel_create(title);

	gtk_main();

	if (filesel_ack) {
		gchar *str;

		str = gtk_file_selection_get_filename
			(GTK_FILE_SELECTION(filesel));
		if (str && str[0] != '\0')
			filename = g_strdup(str);
	}

	gtk_widget_destroy(filesel);
	return filename;
}

static void filesel_create(const gchar *title)
{
	filesel = gtk_file_selection_new(title);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button),
			   "clicked", GTK_SIGNAL_FUNC(filesel_ok_cb),
			   NULL);
	gtk_signal_connect
		(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->cancel_button),
		 "clicked", GTK_SIGNAL_FUNC(filesel_cancel_cb),
		 NULL);
	gtk_signal_connect(GTK_OBJECT(filesel), "delete_event",
			   GTK_SIGNAL_FUNC(filesel_cancel_cb),
			   NULL);
	gtk_window_set_modal(GTK_WINDOW(filesel), TRUE);
	gtk_widget_show_all(filesel);
}

static void filesel_ok_cb(GtkWidget *widget, gpointer data)
{
	filesel_ack = TRUE;
	gtk_main_quit();
}

static void filesel_cancel_cb(GtkWidget *widget, gpointer data)
{
	filesel_ack = FALSE;
	gtk_main_quit();
}
