#ifndef __FILTER_H__
#define __FILTER_H__

typedef struct _Filter	Filter;

typedef enum
{
	FLT_AND,
	FLT_OR,
	FLT_NOT
} FilterCond;

struct _Filter
{
	gchar *name1;
	gchar *body1;

	gchar *name2;
	gchar *body2;

	FilterCond cond;
	gboolean case_sens;

	/* destination folder */
	gchar *dest;
};

gchar *filter_get_dest_folder	(GSList		*fltlist,
				 const gchar	*file);
gboolean filter_match_condition	(Filter		*filter,
				 GSList		*hlist);
gchar *filter_get_str		(Filter		*filter);
Filter *filter_read_str		(const gchar	*str);
void filter_free		(Filter		*filter);

#endif /* __FILTER_H__ */
