#ifndef __FOLDERVIEW_H__
#define __FOLDERVIEW_H__

#include <glib.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtkctree.h>

typedef struct _FolderInfo	FolderInfo;
typedef struct _FolderView	FolderView;

#include "mainwindow.h"
#include "summaryview.h"

typedef enum
{
	F_TOPMAILFOLDER,
	F_MHFOLDER,
	F_TOPNEWSFOLDER,
	F_NEWSSERVER,
	F_NEWSGROUP
} FolderType;

struct _FolderInfo
{
	FolderType type;

	gchar *path;

	gint new;
	gint unread;
	gint total;
};

struct _FolderView
{
	GtkWidget *scrolledwin;
	GtkWidget *ctree;
	GtkWidget *mail_popup;
	GtkWidget *news_popup;

	GtkItemFactory *mail_factory;
	GtkItemFactory *news_factory;

	GtkCTreeNode *mailbox;
	GtkCTreeNode *news;

	GtkCTreeNode *selected;
	GtkCTreeNode *opened;

	gboolean open_folder;

	GdkColor color_new;
	GdkColor color_normal;

	MainWindow   *mainwin;
	SummaryView  *summaryview;
};

FolderView *folderview_create		(void);
void folderview_init			(FolderView	*folderview);
void folderview_set			(FolderView	*folderview);
void folderview_select			(FolderView	*folderview,
					 const gchar	*dir);
void folderview_unselect		(FolderView	*folderview);
void folderview_select_next_unread	(FolderView	*folderview);
void folderview_write_cache		(FolderView	*folderview);
void folderview_update_msg_num		(FolderView	*folderview,
					 GtkCTreeNode	*row,
					 gint		 new,
					 gint		 unread,
					 gint		 total);
void folderview_scan_folder		(FolderView	*folderview,
					 const gchar	*folder);
void folderview_scan_foreach_func	(gpointer	 key,
					 gpointer	 val,
					 gpointer	 data);
void folderview_update_all		(FolderView	*folderview);

#endif /* __FOLDERVIEW_H__ */
