#ifndef __GTKUTILS_H__
#define __GTKUTILS_H__

#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtkctree.h>
#include <gtk/gtkcombo.h>

#define GTK_EVENTS_FLUSH() \
{ \
	while (gtk_events_pending()) \
		gtk_main_iteration(); \
}

#define PIXMAP_CREATE(widget, pixmap, mask, xpm_d) \
{ \
	if (!pixmap) { \
		GtkStyle *style = gtk_widget_get_style(widget); \
		pixmap = gdk_pixmap_create_from_xpm_d \
			(widget->window, &mask, \
			 &style->bg[GTK_STATE_NORMAL], xpm_d); \
	} \
}

#define GTKUT_CTREE_NODE_SET_ROW_DATA(node, d) \
{ \
	GTK_CTREE_ROW(node)->row.data = d; \
}

#define GTKUT_CTREE_NODE_GET_ROW_DATA(node) \
	GTK_CTREE_ROW(node)->row.data

#define GTKUT_CTREE_REFRESH(clist) \
	GTK_CLIST_CLASS(GTK_OBJECT(clist)->klass)->refresh(clist)

gint gtkut_get_font_width(GdkFont *font);
gint gtkut_get_font_height(GdkFont *font);

void gtkut_button_set_create(GtkWidget **bbox,
			     GtkWidget **button1, const gchar *label1,
			     GtkWidget **button2, const gchar *label2,
			     GtkWidget **button3, const gchar *label3);

gint gtkut_ctree_get_nth_from_node(GtkCTree *ctree, GtkCTreeNode *node);
void gtkut_ctree_set_focus_row(GtkCTree *ctree, GtkCTreeNode *node);
void gtkut_clist_set_focus_row(GtkCList *clist, gint row);
void gtkut_combo_set_items(GtkCombo *combo, const gchar *str1, ...);

#endif /* __GTKUTILS_H__ */
