/* headerview.c */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <glib.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtkstyle.h>
#include <gtk/gtkscrolledwindow.h>
#include <gtk/gtktext.h>
#include <gtk/gtkcontainer.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include "intl.h"
#include "main.h"
#include "headerview.h"
#include "prefs_common.h"
#include "utils.h"

static GdkFont *normalfont;
static GdkFont *boldfont;

HeaderView *headerview_create(void)
{
	HeaderView *headerview;
	GtkWidget *scrolledwin;
	GtkWidget *text;

	debug_print(_("Creating header view...\n"));
	headerview = g_new0(HeaderView, 1);

	scrolledwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwin),
				       GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	text = gtk_text_new(gtk_scrolled_window_get_hadjustment
			    (GTK_SCROLLED_WINDOW(scrolledwin)),
			    gtk_scrolled_window_get_vadjustment
			    (GTK_SCROLLED_WINDOW(scrolledwin)));
	gtk_container_add(GTK_CONTAINER(scrolledwin), text);
	GTK_WIDGET_UNSET_FLAGS(text, GTK_CAN_FOCUS);
	gtk_widget_set_usize(scrolledwin, prefs_common.mainview_width,
			     DEFAULT_HEADERVIEW_HEIGHT);

	headerview->scrolledwin = scrolledwin;
	headerview->text = text;

	gtk_widget_show_all(scrolledwin);

	return headerview;
}

void headerview_init(HeaderView *headerview)
{
	GtkStyle *style;

	//if (!normalfont)
	//	normalfont = gdk_fontset_load(NORMAL_FONT);
	if (!boldfont)
		boldfont = gdk_fontset_load(BOLD_FONT);

	style = gtk_style_copy(gtk_widget_get_style(headerview->text));
	//style = gtk_widget_get_style(headerview->text);
	style->base[GTK_STATE_NORMAL] = style->bg[GTK_STATE_NORMAL];
	//style->font = normalfont;
	gtk_widget_set_style(headerview->text, style);

	_("From: ");
	_("To: ");
	_("Newsgroups: ");
	_("Subject: ");
}

#define TR(str)	(prefs_common.trans_hdr ? gettext(str) : str)

void headerview_show(HeaderView *headerview, MsgInfo *msginfo)
{
	GtkText *text = GTK_TEXT(headerview->text);

	gtk_text_freeze(text);
	gtk_text_backward_delete(text, gtk_text_get_length(text));

	gtk_text_thaw(text);
	gtk_text_freeze(text);

	gtk_text_insert(text, boldfont  , NULL, NULL, TR("From: "), -1);
	gtk_text_insert(text, normalfont, NULL, NULL,
			msginfo->from ? msginfo->from : _("(No From)"), -1);

	if (msginfo->to) {
		gtk_text_insert(text, NULL      , NULL, NULL, "  " , 2);
		gtk_text_insert(text, boldfont  , NULL, NULL, TR("To: ") , -1);
		gtk_text_insert(text, normalfont, NULL, NULL, msginfo->to , -1);
	}
	if (msginfo->newsgroups) {
		gtk_text_insert(text, NULL, NULL, NULL, "  ", 2);
		gtk_text_insert(text, boldfont, NULL, NULL, TR("Newsgroups: "), -1);
		gtk_text_insert(text, normalfont, NULL, NULL,
				msginfo->newsgroups, -1);
	}
	gtk_text_insert(text, NULL      , NULL, NULL, "\n", 1);

	gtk_text_insert(text, boldfont  , NULL, NULL, TR("Subject: "), -1);
	gtk_text_insert(text, normalfont, NULL, NULL,
			msginfo->subject ? msginfo->subject :
			_("(No Subject)"), -1);
	gtk_text_thaw(text);
}
