/* headerwindow.c */

#include <glib.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtkwindow.h>
#include <gtk/gtksignal.h>
#include <gtk/gtkcontainer.h>
#include <gtk/gtkscrolledwindow.h>
#include <gtk/gtktext.h>
#include <stdio.h>
#include <string.h>

#include "main.h"
#include "headerwindow.h"
#include "mainwindow.h"
#include "procheader.h"
#include "procmsg.h"
#include "utils.h"
#include "unmime.h"

static GdkFont *normalfont;
static GdkFont *boldfont;

HeaderWindow *header_window_create(void)
{
	HeaderWindow *headerwin;
	GtkWidget *window;
	GtkWidget *scrolledwin;
	GtkWidget *text;

	debug_print(_("Creating header window...\n"));
	headerwin = g_new0(HeaderWindow, 1);

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window), _("All header"));
	gtk_window_set_policy(GTK_WINDOW(window), TRUE, TRUE, FALSE);
	gtk_widget_set_usize(window, 600, 500);
	gtk_signal_connect(GTK_OBJECT(window), "delete_event",
			   GTK_SIGNAL_FUNC(gtk_widget_hide_on_delete), NULL);
	gtk_widget_realize(window);

	scrolledwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwin),
				       GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
	gtk_container_add(GTK_CONTAINER(window), scrolledwin);
	gtk_widget_show(scrolledwin);

	text = gtk_text_new(gtk_scrolled_window_get_hadjustment
			    (GTK_SCROLLED_WINDOW(scrolledwin)),
			    gtk_scrolled_window_get_vadjustment
			    (GTK_SCROLLED_WINDOW(scrolledwin)));
	gtk_container_add(GTK_CONTAINER(scrolledwin), text);
	gtk_widget_show(text);

	headerwin->window = window;
	headerwin->scrolledwin = scrolledwin;
	headerwin->text = text;

	return headerwin;
}

void header_window_init(HeaderWindow *headerwin)
{
	//if (!normalfont)
	//	normalfont = gdk_fontset_load(NORMAL_FONT);
	if (!boldfont)
		boldfont = gdk_fontset_load(BOLD_FONT);
}

void header_window_show(HeaderWindow *headerwin, const gchar *file)
{
	FILE *fp;
	gchar buf[BUFFSIZE], tmp[BUFFSIZE];
	GtkText *text = GTK_TEXT(headerwin->text);
	gchar *p;

	if ((fp = fopen(file, "r")) == NULL) {
		fprintf(stderr, "%s: ", file);
		perror("fopen");
		return;
	}

	g_snprintf(buf, sizeof(buf), _("%s - All header"), file);
	gtk_window_set_title(GTK_WINDOW(headerwin->window), buf);

	gtk_text_freeze(text);
	gtk_text_backward_delete(text, gtk_text_get_length(text));
	gtk_text_thaw(text);
	gtk_text_freeze(text);

	while (procheader_get_one_field(buf, sizeof(buf), fp, NULL) != -1) {
		UnMimeHeader(buf);
		conv_jistoeuc(tmp, sizeof(tmp), buf);
		conv_unreadable(tmp);
		if ((p = strstr(tmp, ": ")) != NULL) {
			gtk_text_insert(text, boldfont, NULL, NULL,
					tmp, p - tmp + 1);
			gtk_text_insert(text, normalfont, NULL, NULL,
					p + 1, -1);
		} else
			gtk_text_insert(text, normalfont, NULL, NULL, tmp, -1);
		gtk_text_insert(text, NULL, NULL, NULL, "\n", 1);
	}

	fclose(fp);
	gtk_text_thaw(text);
}

void header_window_show_cb(gpointer data, guint action, GtkWidget *widget)
{
	MainWindow *mainwin = data;
	SummaryView *summaryview = mainwin->summaryview;
	GtkCTreeNode *node = mainwin->summaryview->displayed;
	MsgInfo *msginfo;
	gchar *file;

	if (node && !GTK_WIDGET_VISIBLE(mainwin->headerwin->window)) {
		msginfo = gtk_ctree_node_get_row_data
			(GTK_CTREE(mainwin->summaryview->ctree), node);
		if (summaryview->mode == SUMMARY_MAIL)
			file = g_strdup_printf("%s%c%d",
					       summaryview->cur_folder,
					       G_DIR_SEPARATOR,
					       msginfo->msgnum);
		else
			file = g_strdup_printf("%s%c%s%c%d",
					       get_news_cache_dir(),
					       G_DIR_SEPARATOR,
					       summaryview->cur_folder,
					       G_DIR_SEPARATOR,
					       msginfo->msgnum);
		header_window_show(mainwin->headerwin, file);
		g_free(file);
	}

	gtk_widget_show(mainwin->headerwin->window);
}
