/* import.c */

#include <glib.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtkwindow.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtktable.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkentry.h>
#include <gtk/gtkhbbox.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtkfilesel.h>
#include <gtk/gtksignal.h>

#include "main.h"
#include "inc.h"
#include "mbox.h"
#include "filesel.h"
#include "foldersel.h"
#include "gtkutils.h"

static GtkWidget *window;
static GtkWidget *file_entry;
static GtkWidget *dest_entry;
static GtkWidget *file_button;
static GtkWidget *dest_button;
static GtkWidget *ok_button;
static GtkWidget *cancel_button;
static gboolean import_ack;

static void import_create(void);
static void import_ok_cb(GtkWidget *widget, gpointer data);
static void import_cancel_cb(GtkWidget *widget, gpointer data);
static void import_filesel_cb(GtkWidget *widget, gpointer data);
static void import_destsel_cb(GtkWidget *widget, gpointer data);

gint import_mbox(void)
{
	gint ok = 0;

	if (!window)
		import_create();
	gtk_widget_show(window);

	gtk_main();

	if (import_ack) {
		gchar *filename, *destdir;

		filename = gtk_entry_get_text(GTK_ENTRY(file_entry));
		destdir = gtk_entry_get_text(GTK_ENTRY(dest_entry));
		if (filename && *filename) {
			if (!destdir || !*destdir) {
				destdir = g_strconcat
					(maildir, "/", INBOX_DIR, NULL);
				ok = proc_mbox(destdir, filename);
				g_free(destdir);
			} else
				ok = proc_mbox(destdir, filename);
		}
	}

	gtk_widget_hide(window);

	return ok;
}

static void import_create(void)
{
	GtkWidget *vbox;
	GtkWidget *table;
	GtkWidget *file_label;
	GtkWidget *dest_label;
	GtkWidget *confirm_area;

	window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(window), _("Import"));
	gtk_widget_set_usize(window, 450, -1);
	gtk_container_set_border_width(GTK_CONTAINER(window), 4);
	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
	gtk_window_set_modal(GTK_WINDOW(window), TRUE);
	gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
	gtk_signal_connect(GTK_OBJECT(window), "delete_event",
			   GTK_SIGNAL_FUNC(import_cancel_cb), NULL);

	vbox = gtk_vbox_new(FALSE, 8);
	gtk_container_add(GTK_CONTAINER(window), vbox);

	table = gtk_table_new(2, 3, FALSE);
	gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(table), 8);
	gtk_table_set_row_spacings(GTK_TABLE(table), 12);
	gtk_table_set_col_spacings(GTK_TABLE(table), 8);

	file_label = gtk_label_new(_("Importing file:"));
	gtk_table_attach(GTK_TABLE(table), file_label, 0, 1, 0, 1,
			 GTK_FILL, GTK_EXPAND|GTK_FILL, 0, 0);
	gtk_misc_set_alignment(GTK_MISC(file_label), 1, 0.5);

	dest_label = gtk_label_new(_("Destination dir:"));
	gtk_table_attach(GTK_TABLE(table), dest_label, 0, 1, 1, 2,
			 GTK_FILL, GTK_EXPAND|GTK_FILL, 0, 0);
	gtk_misc_set_alignment(GTK_MISC(dest_label), 1, 0.5);

	file_entry = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), file_entry, 1, 2, 0, 1,
			 GTK_EXPAND|GTK_SHRINK|GTK_FILL, 0, 0, 0);

	dest_entry = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), dest_entry, 1, 2, 1, 2,
			 GTK_EXPAND|GTK_SHRINK|GTK_FILL, 0, 0, 0);

	file_button = gtk_button_new_with_label(_(" Select... "));
	gtk_table_attach(GTK_TABLE(table), file_button, 2, 3, 0, 1,
			 0, 0, 0, 0);
	gtk_signal_connect(GTK_OBJECT(file_button), "clicked",
			   GTK_SIGNAL_FUNC(import_filesel_cb), NULL);

	dest_button = gtk_button_new_with_label(_(" Select... "));
	gtk_table_attach(GTK_TABLE(table), dest_button, 2, 3, 1, 2,
			 0, 0, 0, 0);
	gtk_signal_connect(GTK_OBJECT(dest_button), "clicked",
			   GTK_SIGNAL_FUNC(import_destsel_cb), NULL);

	gtkut_button_set_create(&confirm_area,
				&ok_button,	_("OK"),
				&cancel_button, _("Cancel"),
				NULL, NULL);
	gtk_box_pack_end(GTK_BOX(vbox), confirm_area, FALSE, FALSE, 0);
	gtk_widget_grab_default(ok_button);

	gtk_signal_connect(GTK_OBJECT(ok_button), "clicked",
			   GTK_SIGNAL_FUNC(import_ok_cb), NULL);
	gtk_signal_connect(GTK_OBJECT(cancel_button), "clicked",
			   GTK_SIGNAL_FUNC(import_cancel_cb), NULL);

	gtk_widget_show_all(window);
}

static void import_ok_cb(GtkWidget *widget, gpointer data)
{
	import_ack = TRUE;
	gtk_main_quit();
}

static void import_cancel_cb(GtkWidget *widget, gpointer data)
{
	import_ack = FALSE;
	gtk_main_quit();
}

static void import_filesel_cb(GtkWidget *widget, gpointer data)
{
	gchar *filename;

	filename = filesel_select_file(_("Select importing file"));
	if (filename)
		gtk_entry_set_text(GTK_ENTRY(file_entry), filename);
}

static void import_destsel_cb(GtkWidget *widget, gpointer data)
{
	gchar *destdir;

	//destdir = filesel_select_file(_("Select destination directory"));
	destdir = foldersel_folder_sel(NULL);
	if (destdir) {
		gtk_entry_set_text(GTK_ENTRY(dest_entry), maildir);
		gtk_entry_append_text(GTK_ENTRY(dest_entry), "/");
		gtk_entry_append_text(GTK_ENTRY(dest_entry), destdir);
	}
}
