#ifndef __MAIN_H__
#define __MAIN_H__

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <glib.h>
#include <gtk/gtkwidget.h>
#include <stdio.h>
#include <string.h>

#include "intl.h"

#define OUT_CHARSET		"ISO-2022-JP"
#define PROG_VERSION		"Sylpheed version "VERSION
#define MAIL_DIR		"Mail"
#define INBOX_DIR		"inbox"
#define OUTBOX_DIR		"outbox"
#define QUEUE_DIR		"queue"
#define DRAFT_DIR		"draft"
#define TRASH_DIR		"trash"
#define RC_DIR			".sylpheed"
#define NEWS_CACHE_DIR		"newscache"
#define COMMON_RC		"sylpheedrc"
#define ACCOUNT_RC		"accountrc"
#define ASSORT_RC		"assortrc"
#define ADDRESS_BOOK		"addressbook"
#define MAIL_FOLDER_LIST	"mailfolder"
#define NEWS_FOLDER_LIST	"newsfolder"
#define CACHE_FILE		".sylpheed_cache"
#define MARK_FILE		".sylpheed_mark"
#define CACHE_VERSION		16
#define MARK_VERSION		2

#define DEFAULT_SIGNATURE	".signature"
#define DEFAULT_INC_PATH	"/usr/bin/mh/inc"
#define DEFAULT_INC_PROGRAM	"inc"
/* #define DEFAULT_INC_PATH	"/usr/bin/imget" */
/* #define DEFAULT_INC_PROGRAM	"imget" */
#define DEFAULT_SPOOL_PATH	"/var/spool/mail"

#define BUFFSIZE			8192
#define MAXPATHLEN			4095
#define DEFAULT_HEIGHT			700
#define DEFAULT_FOLDERVIEW_WIDTH	179
#define DEFAULT_MAINVIEW_WIDTH		600
#define DEFAULT_SUMMARY_HEIGHT		140
#define DEFAULT_HEADERVIEW_HEIGHT	54
#define DEFAULT_COMPOSE_HEIGHT		560
#define BORDER_WIDTH			2
#define CTREE_INDENT			18
#define FOLDER_SPACING			4
#define COLOR_DIM			(guint16)35000

#define NORMAL_FONT	"-*-helvetica-medium-r-normal--12-*," \
			"-*-gothic-medium-r-normal--12-*-*-*-*-*-*-*,*"
#define BOLD_FONT	"-*-helvetica-bold-r-normal--12-*," \
			"-*-gothic-bold-r-normal--12-*-*-*-*-*-*-*,*"
#define SMALL_FONT	"-*-helvetica-medium-r-normal--10-*," \
			"-*-gothic-medium-r-normal--10-*-*-*-*-*-*-*,*"

extern gchar *prog_version;
extern gchar *maildir;
extern gboolean debug_mode;

void app_will_exit	(GtkWidget *widget, gpointer data);

#endif /* __MAIN_H__ */
