/* mainwindow.c */

#include <glib.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkwindow.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtksignal.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkcontainer.h>
#include <gtk/gtkstatusbar.h>
#include <gtk/gtkhpaned.h>
#include <gtk/gtkvpaned.h>
#include <gtk/gtkcheckmenuitem.h>
#include <gtk/gtkitemfactory.h>
#include <gtk/gtkeditable.h>
#include <gtk/gtkmenu.h>
#include <gtk/gtkmenuitem.h>
#include <gtk/gtkhandlebox.h>
#include <gtk/gtktoolbar.h>
#include <string.h>

#include "main.h"
#include "mainwindow.h"
#include "folderview.h"
#include "foldersel.h"
#include "summaryview.h"
#include "summary_search.h"
#include "headerview.h"
#include "messageview.h"
#include "menu.h"
#include "inc.h"
#include "compose.h"
#include "procmsg.h"
#include "import.h"
#include "prefs_common.h"
#include "prefs_account.h"
#include "account.h"
#include "headerwindow.h"
#include "logwindow.h"
#include "manage_window.h"
#include "alertpanel.h"
#include "statusbar.h"
#include "utils.h"
#include "gtkutils.h"
#include "about.h"

#define AC_LABEL_WIDTH	240

static GList *mainwin_list = NULL;
static GdkCursor *watch_cursor;

static void main_window_set_widgets		(MainWindow	*mainwin,
						 SeparateType	 type);
static void main_window_toolbar_create		(MainWindow	*mainwin,
						 GtkWidget	*container);

/* callback functions */
static void toolbar_inc_cb	(GtkWidget	*widget,
				 gpointer	 data);
static void toolbar_inc_all_cb	(GtkWidget	*widget,
				 gpointer	 data);
static void toolbar_compose_cb	(GtkWidget	*widget,
				 gpointer	 data);
static void toolbar_reply_cb	(GtkWidget	*widget,
				 gpointer	 data);
static void toolbar_quote_cb	(GtkWidget	*widget,
				 gpointer	 data);
static void toolbar_forward_cb	(GtkWidget	*widget,
				 gpointer	 data);
static void toolbar_prefs_cb	(GtkWidget	*widget,
				 gpointer	 data);
static void toolbar_account_cb	(GtkWidget	*widget,
				 gpointer	 data);

static gint main_window_close_cb (GtkWidget	*widget,
				  GdkEventAny	*event,
				  gpointer	 data);
static void update_folderview_cb (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);
static void import_mbox_cb	 (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);
static void clean_trash_cb	 (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);
static void app_exit_cb		 (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);

static void toggle_folder_cb	 (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);
static void toggle_message_cb	 (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);
static void toggle_toolbar_cb	 (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);
static void toggle_statusbar_cb	 (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);
static void separate_widget_cb	 (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);

static void log_window_show_cb	(MainWindow	*mainwin,
				 guint		 action,
				 GtkWidget	*widget);

static void inc_mail_cb			(MainWindow	*mainwin,
					 guint		 action,
					 GtkWidget	*widget);
static void inc_all_account_mail_cb	(MainWindow	*mainwin,
					 guint		 action,
					 GtkWidget	*widget);
static void reply_cb			(MainWindow	*mainwin,
					 guint		 action,
					 GtkWidget	*widget);

static void thread_cb		 (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);
static void sort_summary_cb	 (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);
static void attract_by_subject_cb(MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);

static void delete_duplicated_cb (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);
static void assort_cb		 (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);
static void execute_summary_cb	 (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);
static void update_summary_cb	 (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);
static void goto_folder_cb	 (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);

static void copy_cb		 (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);
static void allsel_cb		 (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);

static void prefs_common_open_cb (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);
static void prefs_account_open_cb(MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);
static void new_account_cb	 (MainWindow	*mainwin,
				  guint		 action,
				  GtkWidget	*widget);
static void account_menu_cb	 (GtkMenuItem	*menuitem,
				  gpointer	 data);

static GtkItemFactoryEntry mainwin_entries[] =
{
	{N_("/_File"),				NULL, NULL, 0, "<Branch>"},
	{N_("/_File/_New window"),		"<control>N", NULL, 0, NULL},
	{N_("/_File/_Update folder tree"),	NULL, update_folderview_cb, 0, NULL},
	{N_("/_File/_Import mbox file"),	NULL, import_mbox_cb, 0, NULL},
	{N_("/_File/Clean _trash"),		NULL, clean_trash_cb, 0, NULL},
	{N_("/_File/---"),			NULL, NULL, 0, "<Separator>"},
	{N_("/_File/_Close"),			"<alt>W", app_exit_cb, 0, NULL},
	{N_("/_File/E_xit"),			"<alt>Q", app_exit_cb, 0, NULL},

	{N_("/_Edit"),				NULL, NULL, 0, "<Branch>"},
	{N_("/_Edit/_Undo"),			"<control>Z", NULL, 0, NULL},
	{N_("/_Edit/_Redo"),			"<control>Y", NULL, 0, NULL},
	{N_("/_Edit/---"),			NULL, NULL, 0, "<Separator>"},
	{N_("/_Edit/Cu_t"),			"<control>X", NULL, 0, NULL},
	{N_("/_Edit/_Copy"),			"<control>C", copy_cb, 0, NULL},
	{N_("/_Edit/_Paste"),			"<control>V", NULL, 0, NULL},
	{N_("/_Edit/Select _all"),		"<control>A", allsel_cb, 0, NULL},
	{N_("/_Edit/---"),			NULL, NULL, 0, "<Separator>"},
	{N_("/_Edit/_Search"),			"<control>S", summary_search_cb, 0, NULL},

	{N_("/_Message"),			NULL, NULL, 0, "<Branch>"},
	{N_("/_Message/_Incorporate new mail"),	"<alt>I",	inc_mail_cb, 0, NULL},
	{N_("/_Message/Incorporate new mail of _all accounts"),
						NULL,		inc_all_account_mail_cb, 0, NULL},
	{N_("/_Message/---"),			NULL, NULL, 0, "<Separator>"},
	{N_("/_Message/Compose _new message"),	"<alt>N",	compose_new, 0, NULL},
	{N_("/_Message/_Reply"),		"<alt>R", 	reply_cb, 0, NULL},
	{N_("/_Message/Reply with _quotation"),	"<control>Q",	reply_cb, 1, NULL},
	{N_("/_Message/_Forward"),		"<control>F",	reply_cb, 2, NULL},
	{N_("/_Message/---"),			NULL, NULL, 0, "<Separator>"},
	{N_("/_Message/Show all _header"),	"<control>H",	header_window_show_cb,	0, NULL},
	{N_("/_Message/_Code set"),		NULL, NULL, 0, "<Branch>"},
	{N_("/_Message/_Code set/_Auto detect"),
						NULL, NULL, 0, "<RadioItem>"},
	{N_("/_Message/_Code set/Latin 1 (ISO-8859-1)"),
						NULL, NULL, 0, "/Message/Code set/Auto detect"},
	{N_("/_Message/_Code set/Japanese (ISO-2022-_JP)"),
						NULL, NULL, 0, "/Message/Code set/Auto detect"},
	{N_("/_Message/_Code set/Japanese (_EUC-JP)"),
						NULL, NULL, 0, "/Message/Code set/Auto detect"},
	{N_("/_Message/_Code set/Japanese (_Shift-JIS)"),
						NULL, NULL, 0, "/Message/Code set/Auto detect"},

	{N_("/_Summary"),			NULL, NULL, 0, "<Branch>"},
	{N_("/_Summary/_Delete duplicated messages"),
						NULL, delete_duplicated_cb,   0, NULL},
	{N_("/_Summary/_Assort messages"),	NULL, assort_cb, 0, NULL},
	{N_("/_Summary/E_xecute"),		"<alt>X", execute_summary_cb, 0, NULL},
	{N_("/_Summary/_Update"),		"<alt>U", update_summary_cb,  0, NULL},
	{N_("/_Summary/---"),			NULL, NULL, 0, "<Separator>"},
	{N_("/_Summary/_Go to other folder"),	"<alt>G", goto_folder_cb, 0, NULL},
	{N_("/_Summary/---"),			NULL, NULL, 0, "<Separator>"},
	{N_("/_Summary/Build _Thread"),		"<control>T",	     thread_cb, 0, NULL},
	{N_("/_Summary/Unt_hread"),		"<shift><control>T", thread_cb, 1, NULL},
	{N_("/_Summary/_Sort"),			NULL, NULL, 0, "<Branch>"},
	{N_("/_Summary/_Sort/Sort by _number"),	NULL, sort_summary_cb, SORT_BY_NUMBER, NULL},
	{N_("/_Summary/_Sort/Sort by _date"),	NULL, sort_summary_cb, SORT_BY_DATE, NULL},
	{N_("/_Summary/_Sort/Sort by _from"),	NULL, sort_summary_cb, SORT_BY_FROM, NULL},
	{N_("/_Summary/_Sort/Sort by _subject"),NULL, sort_summary_cb, SORT_BY_SUBJECT, NULL},
	{N_("/_Summary/_Sort/---"),		NULL, NULL, 0, "<Separator>"},
	{N_("/_Summary/_Sort/_Attract by subject"),
						NULL, attract_by_subject_cb, 0, NULL},

	{N_("/_View"),				NULL, NULL, 0, "<Branch>"},
	{N_("/_View/_Folder tree"),		NULL, toggle_folder_cb, 0, "<ToggleItem>"},
	{N_("/_View/_Message view"),		NULL, toggle_message_cb, 0, "<ToggleItem>"},
	{N_("/_View/_Toolbar"),			NULL, NULL, 0, "<Branch>"},
	{N_("/_View/_Toolbar/Icon _and text"),	NULL, toggle_toolbar_cb, TOOLBAR_BOTH, "<RadioItem>"},
	{N_("/_View/_Toolbar/_Icon"),		NULL, toggle_toolbar_cb, TOOLBAR_ICON, "/View/Toolbar/Icon and text"},
	{N_("/_View/_Toolbar/_Text"),		NULL, toggle_toolbar_cb, TOOLBAR_TEXT, "/View/Toolbar/Icon and text"},
	{N_("/_View/_Toolbar/_Non-display"),	NULL, toggle_toolbar_cb, TOOLBAR_NONE, "/View/Toolbar/Icon and text"},
	{N_("/_View/_Status bar"),		NULL, toggle_statusbar_cb, 0, "<ToggleItem>"},
	{N_("/_View/---"),			NULL, NULL, 0, "<Separator>"},
	{N_("/_View/Separate f_older tree"),	NULL, separate_widget_cb, SEPARATE_FOLDER, "<ToggleItem>"},
	{N_("/_View/Separate m_essage view"),	NULL, separate_widget_cb, SEPARATE_MESSAGE, "<ToggleItem>"},

	{N_("/_Tool"),				NULL, NULL, 0, "<Branch>"},
	{N_("/_Tool/_Address book"),		"<alt>A", NULL, 0, NULL},
	{N_("/_Tool/_Log window"),		"<alt>L", log_window_show_cb, 0, NULL},

	{N_("/_Configuration"),			NULL, NULL, 0, "<Branch>"},
	{N_("/_Configuration/_Common preferences..."),
						NULL, prefs_common_open_cb, 0, NULL},
	{N_("/_Configuration/_Preferences per account..."),
						NULL, prefs_account_open_cb, 0, NULL},
	{N_("/_Configuration/---"),		NULL, NULL, 0, "<Separator>"},
	{N_("/_Configuration/Create _new account..."),
						NULL, new_account_cb, 0, NULL},
	{N_("/_Configuration/_Edit accounts..."),
						NULL, account_edit_open, 0, NULL},
	{N_("/_Configuration/C_hange current account"),
						NULL, NULL, 0, "<Branch>"},

	{N_("/_Help"),				NULL, NULL, 0, "<LastBranch>"},
	{N_("/_Help/_About"),			NULL, about_show, 0, NULL}
};

MainWindow *main_window_create(SeparateType type)
{
	MainWindow *mainwin;
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *menubar;
	GtkWidget *handlebox;
	GtkWidget *vbox_body;
	GtkWidget *hbox_stat;
	GtkWidget *statusbar;
	GtkWidget *ac_label;
	GtkWidget *msgpaned;
	FolderView *folderview;
	SummaryView *summaryview;
	MessageView *messageview;
	GdkColormap *colormap;
	GdkColor color[5];
	gboolean success[5];
	guint n_menu_entries;
	GtkItemFactory *ifactory;
	GtkWidget *ac_menu;
	GtkWidget *menuitem;
	gint i;

	debug_print(_("Creating main window...\n"));
	mainwin = g_new0(MainWindow, 1);

	/* main window */
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window), PROG_VERSION);
	gtk_window_set_policy(GTK_WINDOW(window), TRUE, TRUE, FALSE);
	//gtk_widget_set_usize(window, 520, 380);
	//gtk_window_set_default_size(GTK_WINDOW(window),
	//			    -1, prefs_common.mainview_height);
	gtk_widget_set_usize(window, -1, prefs_common.mainview_height);
	gtk_signal_connect(GTK_OBJECT(window), "delete_event",
			   GTK_SIGNAL_FUNC(main_window_close_cb), mainwin);
	gtk_signal_connect(GTK_OBJECT(window), "destroy",
			   GTK_SIGNAL_FUNC(gtk_exit), NULL);
	gtk_signal_connect(GTK_OBJECT(window), "focus_in_event",
			   GTK_SIGNAL_FUNC(manage_window_focus_in), NULL);
	gtk_widget_realize(window);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(window), vbox);

	/* menu bar */
	n_menu_entries = sizeof(mainwin_entries) / sizeof(mainwin_entries[0]);
	menubar = menubar_create(window, mainwin_entries, 
				 n_menu_entries, "<Main>", mainwin);
	gtk_widget_show(menubar);
	gtk_box_pack_start(GTK_BOX(vbox), menubar, FALSE, TRUE, 0);

	handlebox = gtk_handle_box_new();
	gtk_widget_show(handlebox);
	gtk_box_pack_start(GTK_BOX(vbox), handlebox, FALSE, FALSE, 0);

	main_window_toolbar_create(mainwin, handlebox);

	/* vbox that contains body */
	vbox_body = gtk_vbox_new(FALSE, BORDER_WIDTH);
	gtk_widget_show(vbox_body);
	gtk_container_set_border_width(GTK_CONTAINER(vbox_body), BORDER_WIDTH);
	gtk_box_pack_start(GTK_BOX(vbox), vbox_body, TRUE, TRUE, 0);

	hbox_stat = gtk_hbox_new(FALSE, BORDER_WIDTH);
	gtk_box_pack_end(GTK_BOX(vbox_body), hbox_stat, FALSE, FALSE, 0);

	statusbar = statusbar_create();
	gtk_box_pack_start(GTK_BOX(hbox_stat), statusbar, TRUE, TRUE, 0);

	ac_label = gtk_label_new("");
	gtk_box_pack_end(GTK_BOX(hbox_stat), ac_label, FALSE, FALSE, 0);
	gtk_widget_set_usize(ac_label, AC_LABEL_WIDTH, -1);
	gtk_misc_set_alignment(GTK_MISC(ac_label), 0.05, 0.5);

	gtk_widget_show_all(hbox_stat);

	/* create views */
	mainwin->folderview  = folderview  = folderview_create();
	mainwin->summaryview = summaryview = summary_create();
	mainwin->headerview  = headerview_create();
	mainwin->messageview = messageview = messageview_create();
	mainwin->headerwin   = header_window_create();
	mainwin->logwin      = log_window_create();

	folderview->mainwin      = mainwin;
	folderview->summaryview  = summaryview;

	summaryview->mainwin     = mainwin;
	summaryview->folderview  = folderview;
	summaryview->headerview  = mainwin->headerview;
	summaryview->messageview = mainwin->messageview;
	summaryview->headerwin   = mainwin->headerwin;
	summaryview->window      = window;

	messageview->mainwin     = mainwin;

	/* pane which contains the header and the message */
	msgpaned = gtk_vpaned_new();
	gtk_paned_add1(GTK_PANED(msgpaned), mainwin->headerview->scrolledwin);
	gtk_paned_add2(GTK_PANED(msgpaned), mainwin->messageview->scrolledwin);
	gtk_widget_show_all(msgpaned);

	mainwin->window    = window;
	mainwin->vbox      = vbox;
	mainwin->menubar   = menubar;
	mainwin->handlebox = handlebox;
	mainwin->vbox_body = vbox_body;
	mainwin->hbox_stat = hbox_stat;
	mainwin->statusbar = statusbar;
	mainwin->ac_label  = ac_label;
	mainwin->msgpaned  = msgpaned;

	/* set context IDs for status bar */
	mainwin->mainwin_cid = gtk_statusbar_get_context_id
		(GTK_STATUSBAR(statusbar), "Main Window");
	mainwin->folderview_cid = gtk_statusbar_get_context_id
		(GTK_STATUSBAR(statusbar), "Folder View");
	mainwin->summaryview_cid = gtk_statusbar_get_context_id
		(GTK_STATUSBAR(statusbar), "Summary View");

	/* allocate colors for summary view and folder view */
	summaryview->color_marked.red = summaryview->color_marked.green = 0;
	summaryview->color_marked.blue = (guint16)65535;

	summaryview->color_dim.red = summaryview->color_dim.green =
		summaryview->color_dim.blue = COLOR_DIM;

	summaryview->color_normal.red = summaryview->color_normal.green =
		summaryview->color_normal.blue = 0;

	folderview->color_new.red = (guint16)55000;
	folderview->color_new.green = folderview->color_new.blue = 15000;

	folderview->color_normal.red = folderview->color_normal.green =
		folderview->color_normal.blue = 0;

	color[0] = summaryview->color_marked;
	color[1] = summaryview->color_dim;
	color[2] = summaryview->color_normal;
	color[3] = folderview->color_new;
	color[4] = folderview->color_normal;

	colormap = gdk_window_get_colormap(window->window);
	gdk_colormap_alloc_colors(colormap, color, 5, FALSE, TRUE, success);
	for (i = 0; i < 5; i++) {
		if (success[i] == FALSE)
			g_warning(_("MainWindow: color allocation %d failed\n"), i);
	}

	debug_print(_("done.\n"));

	main_window_set_widgets(mainwin, type);

	gtk_widget_show(mainwin->window);
	//gdk_window_move(mainwin->window->window,
	//		prefs_common.mainview_x, prefs_common.mainview_y);
	gtk_widget_set_uposition(mainwin->window,
				 prefs_common.mainview_x,
				 prefs_common.mainview_y);

	/* set menu items */
	ifactory = gtk_item_factory_from_widget(menubar);
	menuitem = gtk_item_factory_get_item(ifactory, "/View/Status bar");
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menuitem), TRUE);

	ifactory = gtk_item_factory_from_widget(menubar);
	switch (prefs_common.toolbar_style) {
	case TOOLBAR_NONE:
		menuitem = gtk_item_factory_get_item
			(ifactory, "/View/Toolbar/Non-display");
		break;
	case TOOLBAR_ICON:
		menuitem = gtk_item_factory_get_item
			(ifactory, "/View/Toolbar/Icon");
		break;
	case TOOLBAR_TEXT:
		menuitem = gtk_item_factory_get_item
			(ifactory, "/View/Toolbar/Text");
		break;
	case TOOLBAR_BOTH:
		menuitem = gtk_item_factory_get_item
			(ifactory, "/View/Toolbar/Icon and text");
	}
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menuitem), TRUE);

	menu_set_sensitive(ifactory, "/File/New window",   FALSE);
	menu_set_sensitive(ifactory, "/Edit/Undo",	   FALSE);
	menu_set_sensitive(ifactory, "/Edit/Redo",	   FALSE);
	menu_set_sensitive(ifactory, "/Edit/Cut",	   FALSE);
	menu_set_sensitive(ifactory, "/Edit/Paste",	   FALSE);
	menu_set_sensitive(ifactory, "/Message/Code set",  FALSE);
	menu_set_sensitive(ifactory, "/Tool/Address book", FALSE);

	/* set account selection menu */
	ac_menu = gtk_item_factory_get_widget
		(ifactory, "/Configuration/Change current account");
	mainwin->ac_menu = ac_menu;

	gtk_widget_set_sensitive(mainwin->reply_btn, FALSE);
	gtk_widget_set_sensitive(mainwin->quote_btn, FALSE);
	gtk_widget_set_sensitive(mainwin->fwd_btn,   FALSE);

	/* initialize views */
	folderview_init(folderview);
	summary_init(summaryview);
	headerview_init(mainwin->headerview);
	messageview_init(mainwin->messageview);
	header_window_init(mainwin->headerwin);
	log_window_init(mainwin->logwin);

	if (!watch_cursor)
		watch_cursor = gdk_cursor_new(GDK_WATCH);

	mainwin_list = g_list_append(mainwin_list, mainwin);

	return mainwin;
}

void main_window_cursor_wait(MainWindow *mainwin)
{
	gdk_window_set_cursor(mainwin->window->window, watch_cursor);

	GTK_EVENTS_FLUSH();
}

void main_window_cursor_normal(MainWindow *mainwin)
{
	gdk_window_set_cursor(mainwin->window->window, NULL);
}

void main_window_set_account_menu(GList *account_list)
{
	GList *cur, *cur_ac, *cur_item;
	GtkWidget *menuitem;
	MainWindow *mainwin;
	PrefsAccount *ac_prefs;

	for (cur = mainwin_list; cur != NULL; cur = cur->next) {
		mainwin = (MainWindow *)cur->data;

		/* destroy all previous menu item */
		cur_item = GTK_MENU_SHELL(mainwin->ac_menu)->children;
		while (cur_item != NULL) {
			GList *next = cur_item->next;
			gtk_widget_destroy(GTK_WIDGET(cur_item->data));
			cur_item = next;
		}

		for (cur_ac = account_list; cur_ac != NULL;
		     cur_ac = cur_ac->next) {
			ac_prefs = (PrefsAccount *)cur_ac->data;

			menuitem = gtk_menu_item_new_with_label
				(ac_prefs->account_name
				 ? ac_prefs->account_name : _("Untitled"));
			gtk_widget_show(menuitem);
			gtk_menu_append(GTK_MENU(mainwin->ac_menu), menuitem);
			gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
					   GTK_SIGNAL_FUNC(account_menu_cb),
					   ac_prefs);
		}
	}
}

void main_window_show_cur_account(void)
{
	GList *cur;
	GtkLabel *label;
	GtkWindow *window;
	gchar *buf;
	gchar *ac_name;

	ac_name = g_strdup(cur_account
			   ? (cur_account->account_name
			      ? cur_account->account_name : _("Untitled"))
			   : _("none"));

	for (cur = mainwin_list; cur != NULL; cur = cur->next) {
		window = GTK_WINDOW(((MainWindow *)cur->data)->window);
		if (cur_account)
			buf = g_strdup_printf("%s - %s",
					      ac_name, PROG_VERSION);
		else
			buf = g_strdup(PROG_VERSION);
		gtk_window_set_title(window, buf);
		g_free(buf);

		label = GTK_LABEL(((MainWindow *)cur->data)->ac_label);
		buf = g_strdup_printf(_("Current account: %s"), ac_name);
		gtk_label_set_text(label, buf);
		g_free(buf);
	}

	g_free(ac_name);
}

void main_window_separation_change(MainWindow *mainwin, SeparateType type)
{
	if (mainwin->type == type)
		return;

	/* remove widgets from those containers */
	gtk_widget_ref(mainwin->folderview->scrolledwin);
	gtk_widget_ref(mainwin->summaryview->vbox);
	gtk_widget_ref(mainwin->msgpaned);
	gtk_container_remove
		(GTK_CONTAINER(mainwin->folderview->scrolledwin->parent),
		 mainwin->folderview->scrolledwin);
	gtk_container_remove
		(GTK_CONTAINER(mainwin->summaryview->vbox->parent),
		 mainwin->summaryview->vbox);
	gtk_container_remove
		(GTK_CONTAINER(mainwin->msgpaned->parent), mainwin->msgpaned);

	/* clean containers */
	switch (mainwin->type) {
	case SEPARATE_NONE:
		gtk_widget_destroy(mainwin->win.sep_none.hpaned);
		break;
	case SEPARATE_FOLDER:
		gtk_widget_destroy(mainwin->win.sep_folder.vpaned);
		gtk_widget_destroy(mainwin->win.sep_folder.folderwin);
		break;
	case SEPARATE_MESSAGE:
		gtk_widget_destroy(mainwin->win.sep_message.hpaned);
		gtk_widget_destroy(mainwin->win.sep_message.messagewin);
		break;
	case SEPARATE_BOTH:
		gtk_widget_destroy(mainwin->win.sep_both.messagewin);
		gtk_widget_destroy(mainwin->win.sep_both.folderwin);
		break;
	}

	main_window_set_widgets(mainwin, type);
	gtk_widget_show(mainwin->window);

	gtk_widget_unref(mainwin->folderview->scrolledwin);
	gtk_widget_unref(mainwin->summaryview->vbox);
	gtk_widget_unref(mainwin->msgpaned);
}

void main_window_get_size(MainWindow *mainwin)
{
	GtkAllocation *allocation;

	allocation = &mainwin->summaryview->scrolledwin->allocation;

	prefs_common.mainview_width = allocation->width;
	prefs_common.mainview_height =
		mainwin->window->allocation.height;

	debug_print(_("allocated mainview size: width = %d, height = %d\n"),
		    allocation->width, mainwin->window->allocation.height);
}

void main_window_get_position(MainWindow *mainwin)
{
	gint x, y;

	gdk_window_get_position(mainwin->window->window, &x, &y);

	prefs_common.mainview_x = x;
	prefs_common.mainview_y = y;

	debug_print(_("window position: x = %d, y = %d\n"), x, y);
}

static void main_window_set_widgets(MainWindow *mainwin, SeparateType type)
{
	GtkWidget *folderwin = NULL;
	GtkWidget *messagewin = NULL;
	GtkWidget *hpaned;
	GtkWidget *vpaned;
	GtkWidget *vbox_body = mainwin->vbox_body;
	//GtkWindow *window = GTK_WINDOW(mainwin->window);

	debug_print(_("Setting widgets..."));

	/* create separated window(s) if needed */
	if (type & SEPARATE_FOLDER) {
		folderwin = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_policy(GTK_WINDOW(folderwin),
				      TRUE, TRUE, FALSE);
		gtk_widget_set_usize(folderwin, -1,
				     prefs_common.mainview_height);
		gtk_container_set_border_width(GTK_CONTAINER(folderwin),
					       BORDER_WIDTH);
		gtk_signal_connect(GTK_OBJECT(folderwin), "delete_event",
				   GTK_SIGNAL_FUNC(gtk_widget_hide_on_delete),
				   NULL);
	}
	if (type & SEPARATE_MESSAGE) {
		messagewin = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_policy(GTK_WINDOW(messagewin),
				      TRUE, TRUE, FALSE);
		gtk_widget_set_usize
			(messagewin, prefs_common.mainview_width,
			 prefs_common.mainview_height - DEFAULT_SUMMARY_HEIGHT
			 + DEFAULT_HEADERVIEW_HEIGHT);
		gtk_container_set_border_width(GTK_CONTAINER(messagewin),
					       BORDER_WIDTH);
		gtk_signal_connect(GTK_OBJECT(messagewin), "delete_event",
				   GTK_SIGNAL_FUNC(gtk_widget_hide_on_delete),
				   NULL);
	}

	switch (type) {
	case SEPARATE_NONE:
		hpaned = gtk_hpaned_new();
		gtk_widget_show(hpaned);
		gtk_box_pack_start(GTK_BOX(vbox_body), hpaned, TRUE, TRUE, 0);
		gtk_paned_add1(GTK_PANED(hpaned), mainwin->folderview->scrolledwin);

		vpaned = gtk_vpaned_new();
		if (mainwin->summaryview->msg_is_toggled_on) {
			gtk_paned_add2(GTK_PANED(hpaned), vpaned);
			gtk_paned_add1(GTK_PANED(vpaned), mainwin->summaryview->vbox);
		} else {
			gtk_paned_add2
				(GTK_PANED(hpaned), mainwin->summaryview->vbox);
			gtk_widget_ref(vpaned);
		}
		gtk_widget_set_usize(mainwin->summaryview->scrolledwin,
				     prefs_common.mainview_width,
				     DEFAULT_SUMMARY_HEIGHT);
		gtk_paned_add2(GTK_PANED(vpaned), mainwin->msgpaned);
		//gtk_window_set_default_size
		//	(window, DEFAULT_FOLDERVIEW_WIDTH + prefs_common.mainview_width + 14, prefs_common.mainview_height);
		gtk_widget_show_all(vpaned);

		mainwin->win.sep_none.hpaned = hpaned;
		mainwin->win.sep_none.vpaned = vpaned;
		break;
	case SEPARATE_FOLDER:
		vpaned = gtk_vpaned_new();
		if (mainwin->summaryview->msg_is_toggled_on) {
			gtk_box_pack_start(GTK_BOX(vbox_body), vpaned,
					   TRUE, TRUE, 0);
			gtk_paned_add1
				(GTK_PANED(vpaned), mainwin->summaryview->vbox);
		} else {
			gtk_box_pack_start(GTK_BOX(vbox_body),
					   mainwin->summaryview->vbox,
					   TRUE, TRUE, 0);
			gtk_widget_ref(vpaned);
		}
		gtk_paned_add2(GTK_PANED(vpaned), mainwin->msgpaned);
		gtk_widget_show_all(vpaned);
		gtk_widget_set_usize(mainwin->summaryview->scrolledwin,
				     prefs_common.mainview_width,
				     DEFAULT_SUMMARY_HEIGHT);

		gtk_container_add(GTK_CONTAINER(folderwin),
				  mainwin->folderview->scrolledwin);

		mainwin->win.sep_folder.folderwin = folderwin;
		mainwin->win.sep_folder.vpaned    = vpaned;

		gtk_widget_show_all(folderwin);
		break;
	case SEPARATE_MESSAGE:
		hpaned = gtk_hpaned_new();
		gtk_box_pack_start(GTK_BOX(vbox_body), hpaned, TRUE, TRUE, 0);

		gtk_paned_add1(GTK_PANED(hpaned), mainwin->folderview->scrolledwin);
		gtk_paned_add2(GTK_PANED(hpaned), mainwin->summaryview->vbox);
		gtk_widget_set_usize(mainwin->summaryview->scrolledwin,
				     prefs_common.mainview_width, -1);
		gtk_widget_show_all(hpaned);
		gtk_container_add(GTK_CONTAINER(messagewin), mainwin->msgpaned);

		mainwin->win.sep_message.messagewin = messagewin;
		mainwin->win.sep_message.hpaned     = hpaned;

		gtk_widget_show_all(messagewin);
		break;
	case SEPARATE_BOTH:
		gtk_box_pack_start(GTK_BOX(vbox_body),
				   mainwin->summaryview->vbox, TRUE, TRUE, 0);
		gtk_widget_set_usize(mainwin->summaryview->scrolledwin,
				     prefs_common.mainview_width, -1);
		gtk_container_add(GTK_CONTAINER(folderwin),
				  mainwin->folderview->scrolledwin);
		gtk_container_add(GTK_CONTAINER(messagewin), mainwin->msgpaned);

		mainwin->win.sep_both.folderwin = folderwin;
		mainwin->win.sep_both.messagewin = messagewin;

		gtk_widget_show_all(folderwin);
		gtk_widget_show_all(messagewin);
		break;
	}

	mainwin->type = type;

	debug_print(_("done.\n"));
}

#include "pixmaps/stock_mail_receive.xpm"
#include "pixmaps/stock_mail_compose.xpm"
#include "pixmaps/stock_mail_reply.xpm"
#include "pixmaps/stock_mail_forward.xpm"
#include "pixmaps/stock_preferences.xpm"
#include "pixmaps/stock_properties.xpm"

#define CREATE_TOOLBAR_ICON(xpm_d) \
{ \
	icon = gdk_pixmap_create_from_xpm_d(container->window, &mask, \
					    &container->style->white, \
					    xpm_d); \
	icon_wid = gtk_pixmap_new(icon, mask); \
}

static void main_window_toolbar_create(MainWindow *mainwin,
				       GtkWidget *container)
{
	GtkWidget *toolbar;
	GdkPixmap *icon;
	GdkBitmap *mask;
	GtkWidget *icon_wid;
	GtkWidget *get_btn;
	GtkWidget *compose_btn;
	GtkWidget *reply_btn;
	GtkWidget *quote_btn;
	GtkWidget *fwd_btn;
	GtkWidget *prefs_btn;
	GtkWidget *account_btn;

	toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL,
				  GTK_TOOLBAR_BOTH);
	gtk_container_add(GTK_CONTAINER(container), toolbar);
	gtk_container_set_border_width(GTK_CONTAINER(container), 2);
	gtk_toolbar_set_button_relief(GTK_TOOLBAR(toolbar), GTK_RELIEF_NONE);
	gtk_toolbar_set_space_style(GTK_TOOLBAR(toolbar),
				    GTK_TOOLBAR_SPACE_LINE);

	CREATE_TOOLBAR_ICON(stock_mail_receive_xpm);
	get_btn = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
					  _("Get"),
					  _("Incorporate new mail"),
					  "Get",
					  icon_wid, toolbar_inc_cb, mainwin);
	CREATE_TOOLBAR_ICON(stock_mail_receive_xpm);
	get_btn = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
					  _("Get all"),
					  _("Incorporate new mail of all accounts"),
					  "Get all",
					  icon_wid,
					  toolbar_inc_all_cb,
					  mainwin);

	gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

	CREATE_TOOLBAR_ICON(stock_mail_compose_xpm);
	compose_btn = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
					      _("Compose"),
					      _("Compose new message"),
					      "New",
					      icon_wid,
					      toolbar_compose_cb,
					      mainwin);
	CREATE_TOOLBAR_ICON(stock_mail_reply_xpm);
	reply_btn = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
					    _("Reply"),
					    _("Reply to the message"),
					    "Reply",
					    icon_wid,
					    toolbar_reply_cb,
					    mainwin);
	CREATE_TOOLBAR_ICON(stock_mail_reply_xpm);
	quote_btn = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
					    _("Quote"),
					    _("Reply to the message with quotation"),
					    "Quote",
					    icon_wid,
					    toolbar_quote_cb,
					    mainwin);
	CREATE_TOOLBAR_ICON(stock_mail_forward_xpm);
	fwd_btn = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
					  _("Fwd"),
					  _("Forward the message"),
					  "Fwd",
					  icon_wid,
					  toolbar_forward_cb,
					  mainwin);

	gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

	CREATE_TOOLBAR_ICON(stock_preferences_xpm);
	prefs_btn = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
					    _("Prefs"),
					    _("Common preference"),
					    "Prefs",
					    icon_wid,
					    toolbar_prefs_cb,
					    mainwin);
	CREATE_TOOLBAR_ICON(stock_properties_xpm);
	account_btn = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
					      _("Account"),
					      _("Account setting"),
					      "Account",
					      icon_wid,
					      toolbar_account_cb,
					      mainwin);

	mainwin->toolbar     = toolbar;
	mainwin->get_btn     = get_btn;
	mainwin->compose_btn = compose_btn;
	mainwin->reply_btn   = reply_btn;
	mainwin->quote_btn   = quote_btn;
	mainwin->fwd_btn     = fwd_btn;
	mainwin->prefs_btn   = prefs_btn;
	mainwin->account_btn = account_btn;

	gtk_widget_show_all(toolbar);
}

/* callback functions */

static void toolbar_inc_cb	(GtkWidget	*widget,
				 gpointer	 data)
{
	MainWindow *mainwin = (MainWindow *)data;

	inc_mail_cb(mainwin, 0, NULL);
}

static void toolbar_inc_all_cb	(GtkWidget	*widget,
				 gpointer	 data)
{
	MainWindow *mainwin = (MainWindow *)data;

	inc_all_account_mail_cb(mainwin, 0, NULL);
}

static void toolbar_compose_cb	(GtkWidget	*widget,
				 gpointer	 data)
{
	compose_new();
}

static void toolbar_reply_cb	(GtkWidget	*widget,
				 gpointer	 data)
{
	MainWindow *mainwin = (MainWindow *)data;

	reply_cb(mainwin, 0, NULL);
}

static void toolbar_quote_cb	(GtkWidget	*widget,
				 gpointer	 data)
{
	MainWindow *mainwin = (MainWindow *)data;

	reply_cb(mainwin, 1, NULL);
}

static void toolbar_forward_cb	(GtkWidget	*widget,
				 gpointer	 data)
{
	MainWindow *mainwin = (MainWindow *)data;

	reply_cb(mainwin, 2, NULL);
}

static void toolbar_prefs_cb	(GtkWidget	*widget,
				 gpointer	 data)
{
	prefs_common_open();
}

static void toolbar_account_cb	(GtkWidget	*widget,
				 gpointer	 data)
{
	MainWindow *mainwin = (MainWindow *)data;

	prefs_account_open_cb(mainwin, 0, NULL);
}

static gint main_window_close_cb(GtkWidget *widget, GdkEventAny *event,
				 gpointer data)
{
	app_exit_cb(data, 0, widget);

	return TRUE;
}

static void update_folderview_cb(MainWindow *mainwin, guint action,
				 GtkWidget *widget)
{
	summary_show(mainwin->summaryview, NULL, FALSE);
	folderview_update_all(mainwin->folderview);
}

static void import_mbox_cb(MainWindow *mainwin, guint action,
			   GtkWidget *widget)
{
	import_mbox();
}

static void clean_trash_cb(MainWindow *mainwin, guint action,
			   GtkWidget *widget)
{
	if (alertpanel(_("Clean trash"), _("Clean all messages in trash?"),
		       _("OK"), _("Cancel"), NULL) != G_ALERTDEFAULT)
		return;

	procmsg_clean_trash();

	folderview_scan_folder(mainwin->folderview, TRASH_DIR);

	if (!strcmp2(mainwin->summaryview->cur_folder, TRASH_DIR)) {
		folderview_unselect(mainwin->folderview);
		folderview_select(mainwin->folderview, TRASH_DIR);
	}
}

static void app_exit_cb(MainWindow *mainwin, guint action, GtkWidget *widget)
{
	if (prefs_common.confirm_on_exit) {
		if (alertpanel(_("Exit"), _("Exit this program?"),
			       _("OK"), _("Cancel"), NULL) != G_ALERTDEFAULT)
			return;
	}

	app_will_exit(widget, mainwin);
	gtk_main_quit();
}

static void toggle_folder_cb(MainWindow *mainwin, guint action,
			     GtkWidget *widget)
{
	switch (mainwin->type) {
	case SEPARATE_NONE:
	case SEPARATE_MESSAGE:
		break;
	case SEPARATE_FOLDER:
		if (GTK_CHECK_MENU_ITEM(widget)->active)
			gtk_widget_show(mainwin->win.sep_folder.folderwin);
		else
			gtk_widget_hide(mainwin->win.sep_folder.folderwin);
		break;
	case SEPARATE_BOTH:
		if (GTK_CHECK_MENU_ITEM(widget)->active)
			gtk_widget_show(mainwin->win.sep_both.folderwin);
		else
			gtk_widget_hide(mainwin->win.sep_both.folderwin);
		break;
	}
}

static void toggle_message_cb(MainWindow *mainwin, guint action,
			      GtkWidget *widget)
{
	switch (mainwin->type) {
	case SEPARATE_NONE:
	case SEPARATE_FOLDER:
		break;
	case SEPARATE_MESSAGE:
		if (GTK_CHECK_MENU_ITEM(widget)->active)
			gtk_widget_show(mainwin->win.sep_message.messagewin);
		else
			gtk_widget_hide(mainwin->win.sep_message.messagewin);
		break;
	case SEPARATE_BOTH:
		if (GTK_CHECK_MENU_ITEM(widget)->active)
			gtk_widget_show(mainwin->win.sep_both.messagewin);
		else
			gtk_widget_hide(mainwin->win.sep_both.messagewin);
		break;
	}
}

static void toggle_toolbar_cb(MainWindow *mainwin, guint action,
			      GtkWidget *widget)
{
	switch (action) {
	case TOOLBAR_NONE:
		gtk_widget_hide(mainwin->handlebox);
	case TOOLBAR_ICON:
		gtk_toolbar_set_style(GTK_TOOLBAR(mainwin->toolbar),
				      GTK_TOOLBAR_ICONS);
		break;
	case TOOLBAR_TEXT:
		gtk_toolbar_set_style(GTK_TOOLBAR(mainwin->toolbar),
				      GTK_TOOLBAR_TEXT);
		break;
	case TOOLBAR_BOTH:
		gtk_toolbar_set_style(GTK_TOOLBAR(mainwin->toolbar),
				      GTK_TOOLBAR_BOTH);
		break;
	}

	if (action != TOOLBAR_NONE) {
		gtk_widget_show(mainwin->handlebox);
		gtk_widget_queue_resize(mainwin->handlebox);
	}

	mainwin->toolbar_style = (ToolbarStyle)action;
	prefs_common.toolbar_style = (ToolbarStyle)action;
}

static void toggle_statusbar_cb(MainWindow *mainwin, guint action,
				GtkWidget *widget)
{
	if (GTK_CHECK_MENU_ITEM(widget)->active)
		gtk_widget_show(mainwin->hbox_stat);
	else
		gtk_widget_hide(mainwin->hbox_stat);
}

static void separate_widget_cb(MainWindow *mainwin, guint action,
			       GtkWidget *widget)
{
	SeparateType type;

	type = mainwin->type ^ action;
	main_window_separation_change(mainwin, type);
}

static void log_window_show_cb(MainWindow *mainwin, guint action,
			       GtkWidget *widget)
{
	log_window_show(mainwin->logwin);
}

static void inc_mail_cb(MainWindow *mainwin, guint action, GtkWidget *widget)
{
	inc_mail(mainwin);

	folderview_unselect(mainwin->folderview);
	folderview_select(mainwin->folderview,
			  cur_account && cur_account->inbox ?
			  cur_account->inbox : INBOX_DIR);
}

static void inc_all_account_mail_cb(MainWindow *mainwin, guint action,
				    GtkWidget *widget)
{
	inc_all_account_mail(mainwin);

	folderview_unselect(mainwin->folderview);
	folderview_select(mainwin->folderview,
			  cur_account && cur_account->inbox ?
			  cur_account->inbox : INBOX_DIR);
}

static void reply_cb(MainWindow *mainwin, guint action,
		     GtkWidget *widget)
{
	MsgInfo *msginfo;

	msginfo = gtk_ctree_node_get_row_data
		(GTK_CTREE(mainwin->summaryview->ctree),
		 mainwin->summaryview->selected);

	if (!msginfo) return;

	switch (action) {
	case 0:
		compose_reply(msginfo);
		break;
	case 1:
		compose_quote(msginfo);
		break;
	case 2:
		compose_forward(msginfo);
		break;
	default:
		compose_reply(msginfo);
	}
}

static void thread_cb(MainWindow *mainwin, guint action, GtkWidget *widget)
{
	if (0 == action)
		summary_thread_build(mainwin->summaryview);
	else
		summary_unthread(mainwin->summaryview);
}

static void sort_summary_cb(MainWindow *mainwin, guint action,
			    GtkWidget *widget)
{
	summary_sort(mainwin->summaryview, (SummarySortType)action);
}

static void attract_by_subject_cb(MainWindow *mainwin, guint action,
				  GtkWidget *widget)
{
	summary_attract_by_subject(mainwin->summaryview);
}

static void delete_duplicated_cb(MainWindow *mainwin, guint action,
				 GtkWidget *widget)
{
	summary_delete_duplicated(mainwin->summaryview);
}

static void assort_cb(MainWindow *mainwin, guint action, GtkWidget *widget)
{
	summary_assort(mainwin->summaryview);
}

static void execute_summary_cb(MainWindow *mainwin, guint action,
			       GtkWidget *widget)
{
	summary_execute(mainwin->summaryview);
}

static void update_summary_cb(MainWindow *mainwin, guint action,
			      GtkWidget *widget)
{
	FolderInfo *finfo;
	FolderView *folderview = mainwin->folderview;

	if (!mainwin->summaryview->cur_folder) return;
	if (!folderview->opened) return;

	finfo = gtk_ctree_node_get_row_data(GTK_CTREE(folderview->ctree),
					    folderview->opened);
	if (!finfo) return;

	summary_show(mainwin->summaryview, finfo, TRUE);
}

static void goto_folder_cb(MainWindow *mainwin, guint action,
			   GtkWidget *widget)
{
	gchar *to_folder;

	to_folder = foldersel_folder_sel(NULL);

	if (to_folder) {
		debug_print(_("Go to %s\n"), to_folder);
		folderview_select(mainwin->folderview, to_folder);
	}
}

static void copy_cb(MainWindow *mainwin, guint action, GtkWidget *widget)
{
	gtk_editable_copy_clipboard(GTK_EDITABLE(mainwin->messageview->text));
}

static void allsel_cb(MainWindow *mainwin, guint action, GtkWidget *widget)
{
	if (!GTK_WIDGET_VISIBLE(mainwin->messageview->text)) return;

	gtk_editable_select_region(GTK_EDITABLE(mainwin->messageview->text),
				   0, -1);
}

static void prefs_common_open_cb(MainWindow *mainwin, guint action,
				 GtkWidget *widget)
{
	prefs_common_open();
}

static void prefs_account_open_cb(MainWindow *mainwin, guint action,
				  GtkWidget *widget)
{
	if (!cur_account) {
		new_account_cb(mainwin, 0, widget);
	} else {
		gboolean prev_default = cur_account->is_default;

		prefs_account_open(cur_account);
		if (!prev_default && cur_account->is_default)
			account_set_as_default(cur_account);
		account_save_config_all();
		account_set_menu();
		main_window_show_cur_account();
	}
}

static void new_account_cb(MainWindow *mainwin, guint action,
			   GtkWidget *widget)
{
	account_edit_open();
	account_add();
}

static void account_menu_cb(GtkMenuItem	*menuitem, gpointer data)
{
	cur_account = (PrefsAccount *)data;
	main_window_show_cur_account();
}
