#ifndef __MAINWINDOW_H__
#define __MAINWINDOW_H__

#include <glib.h>

typedef struct _MainWindow	MainWindow;

#include "folderview.h"
#include "summaryview.h"
#include "headerview.h"
#include "messageview.h"
#include "headerwindow.h"
#include "logwindow.h"

typedef enum
{
	SEPARATE_NONE	 = 0,
	SEPARATE_FOLDER	 = 1 << 0,
	SEPARATE_MESSAGE = 1 << 1,
	SEPARATE_BOTH	 = (SEPARATE_FOLDER | SEPARATE_MESSAGE)
} SeparateType;

typedef enum
{
	TOOLBAR_NONE	= 0,
	TOOLBAR_ICON	= 1,
	TOOLBAR_TEXT	= 2,
	TOOLBAR_BOTH	= 3
} ToolbarStyle;

struct _MainWindow
{
	SeparateType type;

	union CompositeWin {
		struct 
		{
			GtkWidget *hpaned;
			GtkWidget *vpaned;
		} sep_none;
		struct {
			GtkWidget *folderwin;
			GtkWidget *vpaned;
		} sep_folder;
		struct {
			GtkWidget *messagewin;
			GtkWidget *hpaned;
		} sep_message;
		struct {
			GtkWidget *folderwin;
			GtkWidget *messagewin;
		} sep_both;
	} win;

	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *menubar;

	/* tool bar */
	GtkWidget *handlebox;
	GtkWidget *toolbar;
	GtkWidget *get_btn;
	GtkWidget *compose_btn;
	GtkWidget *reply_btn;
	GtkWidget *quote_btn;
	GtkWidget *fwd_btn;
	GtkWidget *prefs_btn;
	GtkWidget *account_btn;

	/* body */
	GtkWidget *vbox_body;
	GtkWidget *hbox_stat;
	GtkWidget *statusbar;
	GtkWidget *ac_label;
	GtkWidget *msgpaned;
	GtkWidget *ac_menu;

	/* context IDs for status bar */
	gint mainwin_cid;
	gint folderview_cid;
	gint summaryview_cid;

	ToolbarStyle toolbar_style;

	FolderView	*folderview;
	SummaryView	*summaryview;
	HeaderView	*headerview;
	MessageView	*messageview;
	HeaderWindow	*headerwin;
	LogWindow	*logwin;
};

MainWindow *main_window_create(SeparateType type);
void main_window_cursor_wait(MainWindow *mainwin);
void main_window_cursor_normal(MainWindow *mainwin);
void main_window_set_account_menu(GList *account_list);
void main_window_show_cur_account(void);
void main_window_separation_change(MainWindow *mainwin, SeparateType type);
void main_window_get_size(MainWindow *mainwin);
void main_window_get_position(MainWindow *mainwin);

#endif /* __MAINWINDOW_H__ */
