#ifndef __NEWS_H__
#define __NEWS_H__

#include <glib.h>

typedef struct _NNTPSession	NNTPSession;

typedef enum {
	NNTP_READY,
	NNTP_SEND,
	NNTP_RECV
} NNTPPhase;

struct _NNTPSession
{
	gchar *server;
	gint   sock;

	gboolean connected;
	NNTPPhase phase;

	gchar *group;

	gpointer data;
};

NNTPSession *news_connection_create	(const gchar	*server,
					 gushort	 port);
NNTPSession *news_session_get		(const gchar	*server);
gint news_get_article_cmd		(NNTPSession	*session,
					 const gchar	*cmd,
					 gint		 num,
					 gchar		*filename);
gint news_get_article			(NNTPSession	*session,
					 gint		 num,
					 gchar		*filename);
gint news_get_header			(NNTPSession	*session,
					 gint		 num,
					 gchar		*filename);
GSList *news_get_article_info		(NNTPSession	*session,
					 const gchar	*path,
					 gboolean	 use_cache);

#endif /* __NEWS_H__ */
