#ifndef __NNTP_H__
#define __NNTP_H__

#define NN_SUCCESS	0
#define NN_SOCKET	2
#define NN_AUTHFAIL	3
#define NN_PROTOCOL	4
#define NN_SYNTAX	5
#define NN_IOERR	6
#define NN_ERROR	7

#define NNTPBUFSIZE	1024

gint nntp_open(const gchar *server, gushort port, gchar *buf);
gint nntp_group(gint sock, const gchar *group,
		gint *num, gint *first, gint *last);
gint nntp_get_article(gint sock, const gchar *cmd, gint num, gchar **msgid);
gint nntp_article(gint sock, gint num, gchar **msgid);
gint nntp_body(gint sock, gint num, gchar **msgid);
gint nntp_head(gint sock, gint num, gchar **msgid);
gint nntp_stat(gint sock, gint num, gchar **msgid);
gint nntp_next(gint sock, gint *num, gchar **msgid);
gint nntp_xover(gint sock, gint first, gint last);
gint nntp_newgroups(gint sock);
gint nntp_newnews(gint sock);
gint nntp_ok(gint sock, gchar *argbuf);

#endif /* __NNTP_H__ */
