#ifndef __POP_H__
#define __POP_H__

#include <glib.h>

typedef enum {
	POP3,
	APOP,
	RPOP
} Pop3Protocol;

/* exit code values */
#define		PS_SUCCESS	0	/* successful receipt of messages */
#define		PS_NOMAIL	1	/* no mail available */
#define		PS_SOCKET	2	/* socket I/O woes */
#define		PS_AUTHFAIL	3	/* user authorization failed */
#define		PS_PROTOCOL	4	/* protocol violation */
#define		PS_SYNTAX	5	/* command-line syntax error */
#define		PS_IOERR	6	/* bad permissions on rc file */
#define		PS_ERROR	7	/* protocol error */
#define		PS_EXCLUDE	8	/* client-side exclusion error */
#define		PS_LOCKBUSY	9	/* server responded lock busy */
#define		PS_SMTP		10	/* SMTP error */
#define		PS_DNS		11	/* fatal DNS error */
#define		PS_BSMTP	12	/* output batch could not be opened */
#define		PS_MAXFETCH	13	/* poll ended by fetch limit */
/* leave space for more codes */
#define		PS_UNDEFINED	23	/* something I hadn't thought of */
#define		PS_TRANSIENT	24	/* transient failure (internal use) */
#define		PS_REFUSED	25	/* mail refused (internal use) */
#define		PS_RETAINED	26	/* message retained (internal use) */
#define		PS_TRUNCATED	27	/* headers incomplete (internal use) */

gint pop3_open(const gchar *server, gushort port, gchar *buf);
gint pop3_get_auth(gint sock, Pop3Protocol proto, const gchar *user,
		   const gchar *pass, const gchar *greeting);
gint pop3_get_range(gint sock, gint *count, gint *new, gint *bytes);
gint pop3_get_sizes(gint sock, gint count, gint *sizes);
gint pop3_fetch(gint sock, gint num, gint *len, gboolean remove_mail);
gint pop3_get_top_id(gint sock, gint num, gchar *id);
gint pop3_ok(gint sock, gchar *argbuf);
gint pop3_delete(gint sock, gint num);
gint pop3_logout(gint sock);

#endif /* __POP_H__ */
