#ifndef __PREFS_H__
#define __PREFS_H__

#include <glib.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtksignal.h>
#include <gtk/gtklabel.h>
#include <gtk/gtknotebook.h>
#include <gtk/gtktogglebutton.h>
#include <stdio.h>

typedef struct _PrefParam	PrefParam;
typedef struct _PrefsDialog	PrefsDialog;

#include "account.h"

typedef enum
{
	P_STRING,
	P_INT,
	P_BOOL,
	P_ENUM,
	P_USHORT,
	P_OTHER
} PrefType;

typedef void (*DataSetFunc)   (PrefParam *pparam);
typedef void (*WidgetSetFunc) (PrefParam *pparam);

struct _PrefParam {
	gchar	      *name;
	gchar	      *defval;
	gpointer       data;
	PrefType       type;
	GtkWidget    **widget;
	DataSetFunc    data_set_func;
	WidgetSetFunc  widget_set_func;
};

struct _PrefsDialog 
{
	GtkWidget *window;
	GtkWidget *notebook;

	GtkWidget *ok_btn;
	GtkWidget *cancel_btn;
	GtkWidget *apply_btn;
};

#define SET_NOTEBOOK_LABEL(notebook, str, page_num) \
{ \
	GtkWidget *label; \
 \
	label = gtk_label_new (str); \
	gtk_widget_show (label); \
	gtk_notebook_set_tab_label \
		(GTK_NOTEBOOK (notebook), \
		 gtk_notebook_get_nth_page \
			(GTK_NOTEBOOK (notebook), page_num), \
		 label); \
}

#define SET_TOGGLE_SENSITIVITY(togglewid, targetwid) \
{ \
	gtk_widget_set_sensitive(targetwid, FALSE); \
	gtk_signal_connect(GTK_OBJECT(togglewid), "toggled", \
			   GTK_SIGNAL_FUNC(prefs_button_toggled), targetwid); \
}

void prefs_read_config		(PrefParam	*param,
				 const gchar	*label,
				 const gchar	*rcfile);
void prefs_config_parse_one_line(PrefParam	*param,
				 const gchar	*buf);
void prefs_save_config		(PrefParam	*param,
				 const gchar	*label,
				 const gchar	*rcfile);
void prefs_write_param		(PrefParam	*param,
				 FILE		*fp);
void prefs_set_default		(PrefParam	*param);
void prefs_free			(PrefParam	*param);

void prefs_dialog_create	(PrefsDialog	*dialog);

void prefs_button_toggled	(GtkToggleButton	*toggle_btn,
				 GtkWidget		*widget);

void prefs_set_dialog		(PrefParam	*param);
void prefs_set_data_from_dialog	(PrefParam	*param);
void prefs_set_dialog_to_default(PrefParam	*param);

void prefs_set_data_from_entry	(PrefParam	*pparam);
void prefs_set_entry		(PrefParam	*pparam);
void prefs_set_data_from_text	(PrefParam	*pparam);
void prefs_set_text		(PrefParam	*pparam);
void prefs_set_data_from_toggle	(PrefParam	*pparam);
void prefs_set_toggle		(PrefParam	*pparam);
void prefs_set_data_from_spinbtn(PrefParam	*pparam);
void prefs_set_spinbtn		(PrefParam	*pparam);

#endif __PREFS_H__
