#ifndef __PREFS_ACCOUNT_H__
#define __PREFS_ACCOUNT_H__

#include <glib.h>

typedef struct _PrefsAccount	PrefsAccount;

typedef enum {
	A_POP3,
	A_APOP,
	A_RPOP,
	A_IMAP4,
	A_NNTP,
	A_LOCAL
} RecvProtocol;

struct _PrefsAccount
{
	gchar *account_name;

	/* Personal info */
	gchar *name;
	gchar *address;
	gchar *organization;

	/* Server info */
	RecvProtocol protocol;
	gchar *inbox;
	gchar *recv_server;
	gchar *smtp_server;
	gchar *userid;
	gchar *passwd;

	/* Receive */
	gboolean rmmail;
	gboolean getall;
	gboolean autochk;
	gboolean assort_on_recv;

	/* Send */
	gboolean add_date;
	gboolean gen_msgid;
	gboolean add_customhdr;

	/* Compose */
	gchar *sig_path;

	/* Advanced */
	gboolean  set_smtpport;
	gushort   smtpport;
	gboolean  set_popport;
	gushort   popport;
	gboolean  set_domain;
	gchar    *domain;

	/* Default or not */
	gboolean is_default;
};

void prefs_account_read_config		(PrefsAccount	*ac_prefs,
					 const gchar	*label);
void prefs_account_save_config		(PrefsAccount	*ac_prefs,
					 gint		 id);
void prefs_account_save_config_all	(GList		*account_list);
void prefs_account_free			(PrefsAccount	*ac_prefs);
PrefsAccount *prefs_account_open	(PrefsAccount	*ac_prefs);

#endif /* __PREFS_ACCOUNT_H__ */
