/* prefs_common.c */

#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "main.h"
#include "prefs.h"
#include "prefs_common.h"
#include "mainwindow.h"
#include "messageview.h"
#include "manage_window.h"
#include "filter.h"
#include "foldersel.h"
#include "utils.h"
#include "gtkutils.h"
#include "alertpanel.h"

PrefsCommon prefs_common;

static PrefsDialog dialog;

static struct Compose {
	GtkWidget *entry_quotemark;
	GtkWidget *text_quotefmt;
	GtkWidget *checkbtn_autosig;
} compose;

static struct Receive {
	GtkWidget *checkbtn_incext;
	GtkWidget *entry_incext;
	GtkWidget *button_incext;

	GtkWidget *checkbtn_local;
	GtkWidget *entry_spool;

	GtkWidget *checkbtn_autochk;
	GtkWidget *spinbtn_autochk;
	GtkObject *spinbtn_autochk_adj;

	GtkWidget *checkbtn_chkonstartup;
} receive;

static struct Send {
	GtkWidget *checkbtn_sendext;
	GtkWidget *entry_sendext;
	GtkWidget *button_sendext;

	GtkWidget *checkbtn_savemsg;
	GtkWidget *checkbtn_queuemsg;
} send;

static struct Assort {
	GtkWidget *hdr_combo1;
	GtkWidget *hdr_combo2;
	GtkWidget *hdr_entry1;
	GtkWidget *hdr_entry2;
	GtkWidget *key_entry1;
	GtkWidget *key_entry2;
	GtkWidget *pred_combo1;
	GtkWidget *pred_combo2;
	GtkWidget *pred_entry1;
	GtkWidget *pred_entry2;
	GtkWidget *op_combo;
	GtkWidget *op_entry;

	GtkWidget *dest_entry;
	GtkWidget *regex_chkbtn;

	GtkWidget *cond_clist;
} assort;

static struct Display {
	GtkWidget *entry_widfont;
	GtkWidget *entry_msgfont;
	GtkWidget *button_widfont;
	GtkWidget *button_msgfont;

	GtkWidget *chkbtn_enablecol;
	GtkWidget *button_quotecol;
	GtkWidget *button_urlcol;
	GtkWidget *button_sigcol;

	GtkWidget *chkbtn_transhdr;
} display;

static struct Interface {
	//GtkWidget *checkbtn_sepfolder;
	//GtkWidget *checkbtn_sepmsg;
	GtkWidget *checkbtn_emacs;
	GtkWidget *checkbtn_confonexit;
} interface;

static GtkWidget *quote_desc_win;

/*
   parameter name, default value, pointer to the prefs variable, data type,
   pointer to the widget pointer,
   pointer to the function for data setting,
   pointer to the function for widget setting
 */

static PrefParam param[] = {
	/* Receive */
	{"use_ext_inc", "FALSE", &prefs_common.use_extinc, P_BOOL,
	 &receive.checkbtn_incext,
	 prefs_set_data_from_toggle, prefs_set_toggle},
	{"ext_inc_path", DEFAULT_INC_PATH, &prefs_common.extinc_path, P_STRING,
	 &receive.entry_incext,
	 prefs_set_data_from_entry, prefs_set_entry},

	{"inc_local", "TRUE", &prefs_common.inc_local, P_BOOL,
	 &receive.checkbtn_local,
	 prefs_set_data_from_toggle, prefs_set_toggle},
	{"spool_path", DEFAULT_SPOOL_PATH, &prefs_common.spool_path, P_STRING,
	 &receive.entry_spool,
	 prefs_set_data_from_entry, prefs_set_entry},

	{"autochk_newmail", "FALSE", &prefs_common.autochk_newmail, P_BOOL,
	 &receive.checkbtn_autochk,
	 prefs_set_data_from_toggle, prefs_set_toggle},
	{"autochk_interval", "10", &prefs_common.autochk_itv, P_INT,
	 &receive.spinbtn_autochk,
	 prefs_set_data_from_spinbtn, prefs_set_spinbtn},
	{"check_on_startup", "FALSE", &prefs_common.chk_on_startup, P_BOOL,
	 &receive.checkbtn_chkonstartup,
	 prefs_set_data_from_toggle, prefs_set_toggle},

	/* Send */
	{"use_ext_send", "FALSE", &prefs_common.use_extsend, P_BOOL,
	 &send.checkbtn_sendext,
	 prefs_set_data_from_toggle, prefs_set_toggle},
	{"ext_send_path", NULL, &prefs_common.extsend_path, P_STRING,
	 &send.entry_sendext, prefs_set_data_from_entry, prefs_set_entry},
	{"save_message", "TRUE", &prefs_common.savemsg, P_BOOL,
	 &send.checkbtn_savemsg,
	 prefs_set_data_from_toggle, prefs_set_toggle},
	{"queue_message", "FALSE", &prefs_common.queue_msg, P_BOOL,
	 &send.checkbtn_queuemsg,
	 prefs_set_data_from_toggle, prefs_set_toggle},

	/* Compose */
	{"quote_mark", "> ", &prefs_common.quotemark, P_STRING,
	 &compose.entry_quotemark, prefs_set_data_from_entry, prefs_set_entry},
	{"quote_format", "On %d\\n%f wrote:\\n\\n",
	 &prefs_common.quotefmt, P_STRING, &compose.text_quotefmt,
	 prefs_set_data_from_text, prefs_set_text},

	{"auto_signature", "TRUE", &prefs_common.auto_sig, P_BOOL,
	 &compose.checkbtn_autosig,
	 prefs_set_data_from_toggle, prefs_set_toggle},

	/* Display */
	{"widget_font", NULL, &prefs_common.widgetfont, P_STRING,
	 &display.entry_widfont,
	 prefs_set_data_from_entry, prefs_set_entry},
	{"message_font", "-misc-fixed-medium-r-normal--14-*-*-*-*-*-*-*,*",
	 &prefs_common.messagefont, P_STRING,
	 &display.entry_msgfont,
	 prefs_set_data_from_entry, prefs_set_entry},
	{"enable_color", "TRUE", &prefs_common.enable_color, P_BOOL,
	 &display.chkbtn_enablecol,
	 prefs_set_data_from_toggle, prefs_set_toggle},

	{"quote_color", "0", &prefs_common.quote_col, P_USHORT,
	 NULL, NULL, NULL},
	{"uri_color", "0", &prefs_common.uri_col, P_USHORT,
	 NULL, NULL, NULL},
	{"signature_color", "0", &prefs_common.sig_col, P_USHORT,
	 NULL, NULL, NULL},
	{"toolbar_style", "3", &prefs_common.toolbar_style, P_ENUM,
	 NULL, NULL, NULL},

	{"translate_header", "TRUE", &prefs_common.trans_hdr, P_BOOL,
	 &display.chkbtn_transhdr,
	 prefs_set_data_from_toggle, prefs_set_toggle},

	{"folderview_width", "179", &prefs_common.folderview_width, P_INT,
	 NULL, NULL, NULL},
	{"folderview_height", "700", &prefs_common.folderview_height, P_INT,
	 NULL, NULL, NULL},
	{"mainview_x", "64", &prefs_common.mainview_x, P_INT,
	 NULL, NULL, NULL},
	{"mainview_y", "64", &prefs_common.mainview_y, P_INT,
	 NULL, NULL, NULL},
	{"mainview_width", "600", &prefs_common.mainview_width, P_INT,
	 NULL, NULL, NULL},
	{"mainview_height", "700", &prefs_common.mainview_height, P_INT,
	 NULL, NULL, NULL},

	/* Interface */
#if 0
	{"separate_folder", "FALSE", &prefs_common.sep_folder, P_BOOL,
	 &interface.checkbtn_sepfolder,
	 prefs_set_data_from_toggle, prefs_set_toggle},
	{"separate_message", "FALSE", &prefs_common.sep_msg, P_BOOL,
	 &interface.checkbtn_sepmsg,
	 prefs_set_data_from_toggle, prefs_set_toggle},
#endif
	{"separate_folder", "FALSE", &prefs_common.sep_folder, P_BOOL,
	 NULL, NULL, NULL},
	{"separate_message", "FALSE", &prefs_common.sep_msg, P_BOOL,
	 NULL, NULL, NULL},

	{"emulate_emacs", "FALSE", &prefs_common.emulate_emacs, P_BOOL,
	 &interface.checkbtn_emacs,
	 prefs_set_data_from_toggle, prefs_set_toggle},
	{"confirm_on_exit", "TRUE", &prefs_common.confirm_on_exit, P_BOOL,
	 &interface.checkbtn_confonexit,
	 prefs_set_data_from_toggle, prefs_set_toggle},

	{NULL, NULL, NULL, P_OTHER, NULL, NULL, NULL}
};

#define VSPACING	12
#define PREFSBUFSIZE	1024

/* widget creating functions */
static void prefs_common_create		(void);
static void prefs_receive_create	(void);
static void prefs_send_create		(void);
static void prefs_compose_create	(void);
static void prefs_assort_create		(void);
static void prefs_display_create	(void);
static void prefs_interface_create	(void);

static void prefs_quote_description	   (void);
static void prefs_quote_description_create (void);

static void prefs_assort_read_config	(void);
static void prefs_assort_write_config	(void);
static void prefs_assort_set_dialog	(void);
static void prefs_assort_set_list	(void);
static gint prefs_assort_clist_set_row	(gint	 row);

/* callback functions */
static void prefs_assort_select_dest_cb	(void);
static void prefs_assort_register_cb	(void);
static void prefs_assort_substitute_cb	(void);
static void prefs_assort_delete_cb	(void);
static void prefs_assort_up		(void);
static void prefs_assort_down		(void);
static void prefs_assort_select		(GtkCList	*clist,
					 gint		 row,
					 gint		 column,
					 GdkEvent	*event);
static void prefs_common_key_pressed	(GtkWidget	*widget,
					 GdkEventKey	*event,
					 gpointer	 data);
static void prefs_common_ok		(GtkButton	*button);
static void prefs_common_apply		(GtkButton	*button);

void prefs_common_read_config(void)
{
	prefs_read_config(param, "Common", COMMON_RC);
	prefs_assort_read_config();
}

void prefs_common_save_config(void)
{
	prefs_save_config(param, "Common", COMMON_RC);
	prefs_assort_write_config();
}

void prefs_common_open(void)
{
	if (!dialog.window) {
		prefs_common_create();
	}

	manage_window_set_transient(GTK_WINDOW(dialog.window));
	gtk_notebook_set_page(GTK_NOTEBOOK(dialog.notebook), 0);
	gtk_widget_grab_focus(dialog.ok_btn);

	prefs_set_dialog(param);
	prefs_assort_set_dialog();

	gtk_widget_show(dialog.window);
}

static void prefs_common_create(void)
{
	GtkStyle *style;
	gint page = 0;

	debug_print(_("Creating common preferences window...\n"));

	prefs_dialog_create(&dialog);
	gtk_window_set_title (GTK_WINDOW(dialog.window),
			      _("Common Preferences"));
	gtk_signal_connect (GTK_OBJECT(dialog.window), "delete_event",
			    GTK_SIGNAL_FUNC(gtk_widget_hide_on_delete), NULL);
	gtk_signal_connect (GTK_OBJECT(dialog.window), "key_press_event",
			    GTK_SIGNAL_FUNC(prefs_common_key_pressed), NULL);
	gtk_signal_connect (GTK_OBJECT(dialog.window), "focus_in_event",
			    GTK_SIGNAL_FUNC(manage_window_focus_in), NULL);
	gtk_signal_connect (GTK_OBJECT(dialog.ok_btn), "clicked",
			    GTK_SIGNAL_FUNC(prefs_common_ok), NULL);
	gtk_signal_connect (GTK_OBJECT(dialog.apply_btn), "clicked",
			    GTK_SIGNAL_FUNC(prefs_common_apply), NULL);
	gtk_signal_connect_object (GTK_OBJECT(dialog.cancel_btn), "clicked",
				   GTK_SIGNAL_FUNC(gtk_widget_hide_on_delete),
				   GTK_OBJECT(dialog.window));

	prefs_receive_create();
	SET_NOTEBOOK_LABEL(dialog.notebook, _("Receive"), page++);
	prefs_send_create();
	SET_NOTEBOOK_LABEL(dialog.notebook, _("Send"), page++);
	prefs_compose_create();
	SET_NOTEBOOK_LABEL(dialog.notebook, _("Compose"), page++);
	prefs_display_create();
	SET_NOTEBOOK_LABEL(dialog.notebook, _("Display"), page++);
	prefs_assort_create();
	SET_NOTEBOOK_LABEL(dialog.notebook, _("Assort"), page++);
	prefs_interface_create();
	SET_NOTEBOOK_LABEL(dialog.notebook, _("Interface"), page++);

	gtk_widget_show_all(dialog.window);

	style = gtk_widget_get_style(dialog.window);
	if (style && style->font) {
		gint width, height;

		width = gtkut_get_font_width(style->font);
		height = gtkut_get_font_height(style->font);
		gtk_widget_set_usize(dialog.window, width * 74, height * 32);
	}
}

static void prefs_receive_create(void)
{
	GtkWidget *vbox_recv;
	GtkWidget *frame_incext;
	GtkWidget *vbox;
	GtkWidget *checkbtn_incext;
	GtkWidget *hbox;
	GtkWidget *label_incext;
	GtkWidget *entry_incext;
	GtkWidget *button_incext;

	GtkWidget *frame_spool;
	GtkWidget *checkbtn_local;
	GtkWidget *label_spool;
	GtkWidget *entry_spool;

	GtkWidget *hbox_autochk;
	GtkWidget *checkbtn_autochk;
	GtkWidget *label_autochk1;
	GtkObject *spinbtn_autochk_adj;
	GtkWidget *spinbtn_autochk;
	GtkWidget *label_autochk2;
	GtkWidget *checkbtn_chkonstartup;

	vbox_recv = gtk_vbox_new (FALSE, VSPACING);
	gtk_widget_show (vbox_recv);
	gtk_container_add (GTK_CONTAINER (dialog.notebook), vbox_recv);
	gtk_container_set_border_width (GTK_CONTAINER (vbox_recv), 16);

	frame_incext = gtk_frame_new (_("External program"));
	gtk_widget_show (frame_incext);
	gtk_box_pack_start (GTK_BOX (vbox_recv), frame_incext, FALSE, FALSE, 0);
	gtk_frame_set_label_align (GTK_FRAME (frame_incext), 0.01, 0.5);

	vbox = gtk_vbox_new (FALSE, 8);
	gtk_widget_show (vbox);
	gtk_container_add (GTK_CONTAINER (frame_incext), vbox);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 8);

	/* Use of external incorporation program */
	checkbtn_incext = gtk_check_button_new_with_label
		(_("Use external program for incorporation"));
	gtk_widget_show (checkbtn_incext);
	gtk_box_pack_start (GTK_BOX (vbox), checkbtn_incext, FALSE, FALSE, 0);

	hbox = gtk_hbox_new (FALSE, 8);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	SET_TOGGLE_SENSITIVITY (checkbtn_incext, hbox);

	label_incext = gtk_label_new (_("Program path"));
	gtk_widget_show (label_incext);
	gtk_box_pack_start (GTK_BOX (hbox), label_incext, FALSE, FALSE, 0);

	entry_incext = gtk_entry_new ();
	gtk_widget_show (entry_incext);
	gtk_box_pack_start (GTK_BOX (hbox), entry_incext, TRUE, TRUE, 0);

	button_incext = gtk_button_new_with_label ("... ");
	gtk_widget_show (button_incext);
	gtk_box_pack_start (GTK_BOX (hbox), button_incext, FALSE, FALSE, 0);

	frame_spool = gtk_frame_new (_("Local spool"));
	gtk_widget_show (frame_spool);
	gtk_box_pack_start (GTK_BOX (vbox_recv), frame_spool, FALSE, FALSE, 0);
	gtk_frame_set_label_align (GTK_FRAME (frame_spool), 0.01, 0.5);

	vbox = gtk_vbox_new (FALSE, 8);
	gtk_widget_show (vbox);
	gtk_container_add (GTK_CONTAINER (frame_spool), vbox);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 8);

	checkbtn_local = gtk_check_button_new_with_label
		(_("Incorporate from local spool"));
	gtk_widget_show (checkbtn_local);
	gtk_box_pack_start (GTK_BOX (vbox), checkbtn_local, FALSE, FALSE, 0);

	hbox = gtk_hbox_new (FALSE, 8);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	SET_TOGGLE_SENSITIVITY (checkbtn_local, hbox);

	label_spool = gtk_label_new (_("Spool directory"));
	gtk_widget_show (label_spool);
	gtk_box_pack_start (GTK_BOX (hbox), label_spool, FALSE, FALSE, 0);

	entry_spool = gtk_entry_new ();
	gtk_widget_show (entry_spool);
	gtk_box_pack_start (GTK_BOX (hbox), entry_spool, TRUE, TRUE, 0);

	/* Auto-checking */
	hbox_autochk = gtk_hbox_new (FALSE, 8);
	gtk_widget_show (hbox_autochk);
	gtk_box_pack_start (GTK_BOX (vbox_recv), hbox_autochk, FALSE, FALSE, 0);

	gtk_widget_set_sensitive(hbox_autochk, FALSE);

	checkbtn_autochk = gtk_check_button_new_with_label
		(_("Auto-check new mail"));
	gtk_widget_show (checkbtn_autochk);
	gtk_box_pack_start (GTK_BOX (hbox_autochk), checkbtn_autochk, FALSE, FALSE, 0);

	label_autochk1 = gtk_label_new (_("each"));
	gtk_widget_show (label_autochk1);
	gtk_box_pack_start (GTK_BOX (hbox_autochk), label_autochk1, FALSE, FALSE, 0);

	spinbtn_autochk_adj = gtk_adjustment_new (5, 1, 100, 1, 10, 10);
	spinbtn_autochk = gtk_spin_button_new
		(GTK_ADJUSTMENT (spinbtn_autochk_adj), 1, 0);
	gtk_widget_show (spinbtn_autochk);
	gtk_box_pack_start (GTK_BOX (hbox_autochk), spinbtn_autochk, FALSE, FALSE, 0);
	gtk_widget_set_usize (spinbtn_autochk, 64, -2);
	gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinbtn_autochk), TRUE);

	label_autochk2 = gtk_label_new (_("minute(s)"));
	gtk_widget_show (label_autochk2);
	gtk_box_pack_start (GTK_BOX (hbox_autochk), label_autochk2, FALSE, FALSE, 0);

	SET_TOGGLE_SENSITIVITY(checkbtn_autochk, label_autochk1);
	SET_TOGGLE_SENSITIVITY(checkbtn_autochk, spinbtn_autochk);
	SET_TOGGLE_SENSITIVITY(checkbtn_autochk, label_autochk2);

	checkbtn_chkonstartup = gtk_check_button_new_with_label
		(_("Check new mail on startup"));
	gtk_widget_show (checkbtn_chkonstartup);
	gtk_box_pack_start (GTK_BOX (vbox_recv), checkbtn_chkonstartup, FALSE, FALSE, 0);

	receive.checkbtn_incext = checkbtn_incext;
	receive.entry_incext    = entry_incext;
	receive.button_incext   = button_incext;

	receive.checkbtn_local  = checkbtn_local;
	receive.entry_spool     = entry_spool;

	receive.checkbtn_autochk    = checkbtn_autochk;
	receive.spinbtn_autochk     = spinbtn_autochk;
	receive.spinbtn_autochk_adj = spinbtn_autochk_adj;

	receive.checkbtn_chkonstartup = checkbtn_chkonstartup;
}

static void prefs_send_create(void)
{
	GtkWidget *vbox1;
	GtkWidget *frame_sendext;
	GtkWidget *vbox_sendext;
	GtkWidget *checkbtn_sendext;
	GtkWidget *hbox1;
	GtkWidget *label_sendext;
	GtkWidget *entry_sendext;
	GtkWidget *button_sendext;
	GtkWidget *checkbtn_savemsg;
	GtkWidget *checkbtn_queuemsg;

	vbox1 = gtk_vbox_new (FALSE, VSPACING);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (dialog.notebook), vbox1);
	gtk_container_set_border_width (GTK_CONTAINER (vbox1), 16);

	frame_sendext = gtk_frame_new (_("External program"));
	gtk_widget_show (frame_sendext);
	gtk_box_pack_start (GTK_BOX (vbox1), frame_sendext, FALSE, FALSE, 0);
	gtk_frame_set_label_align (GTK_FRAME (frame_sendext), 0.01, 0.5);

	gtk_widget_set_sensitive(frame_sendext, FALSE);

	vbox_sendext = gtk_vbox_new (FALSE, 8);
	gtk_widget_show (vbox_sendext);
	gtk_container_add (GTK_CONTAINER (frame_sendext), vbox_sendext);
	gtk_container_set_border_width (GTK_CONTAINER (vbox_sendext), 8);

	checkbtn_sendext = gtk_check_button_new_with_label
		(_("Use external program for sending"));
	gtk_widget_show (checkbtn_sendext);
	gtk_box_pack_start (GTK_BOX (vbox_sendext), checkbtn_sendext, FALSE, FALSE, 0);

	hbox1 = gtk_hbox_new (FALSE, 8);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox_sendext), hbox1, FALSE, FALSE, 0);
	SET_TOGGLE_SENSITIVITY(checkbtn_sendext, hbox1);

	label_sendext = gtk_label_new (_("Program path"));
	gtk_widget_show (label_sendext);
	gtk_box_pack_start (GTK_BOX (hbox1), label_sendext, FALSE, FALSE, 0);

	entry_sendext = gtk_entry_new ();
	gtk_widget_show (entry_sendext);
	gtk_box_pack_start (GTK_BOX (hbox1), entry_sendext, TRUE, TRUE, 0);

	button_sendext = gtk_button_new_with_label ("... ");
	gtk_widget_show (button_sendext);
	gtk_box_pack_start (GTK_BOX (hbox1), button_sendext, FALSE, FALSE, 0);

	checkbtn_savemsg = gtk_check_button_new_with_label
		(_("Save sent message to outbox"));
	gtk_widget_show (checkbtn_savemsg);
	gtk_box_pack_start (GTK_BOX (vbox1), checkbtn_savemsg, FALSE, FALSE, 0);

	checkbtn_queuemsg = gtk_check_button_new_with_label
		(_("Queue message that failed to send"));
	gtk_widget_show (checkbtn_queuemsg);
	gtk_box_pack_start (GTK_BOX (vbox1), checkbtn_queuemsg,
			    FALSE, FALSE, 0);

	send.checkbtn_sendext = checkbtn_sendext;
	send.entry_sendext    = entry_sendext;
	send.button_sendext   = button_sendext;

	send.checkbtn_savemsg  = checkbtn_savemsg;
	send.checkbtn_queuemsg = checkbtn_queuemsg;
}

static void prefs_compose_create(void)
{
	GtkWidget *vbox_compose;
	GtkWidget *frame_quote;
	GtkWidget *vbox_quote;
	GtkWidget *hbox1;
	GtkWidget *label_quotemark;
	GtkWidget *entry_quotemark;
	GtkWidget *hbox2;
	GtkWidget *label_quotefmt;
	GtkWidget *btn_quotedesc;
	GtkWidget *scrolledwin_quotefmt;
	GtkWidget *text_quotefmt;
	GtkWidget *checkbtn_autosig;

	vbox_compose = gtk_vbox_new (FALSE, VSPACING);
	gtk_widget_show (vbox_compose);
	gtk_container_add (GTK_CONTAINER (dialog.notebook),
			   vbox_compose);
	gtk_container_set_border_width (GTK_CONTAINER (vbox_compose), 16);

	frame_quote = gtk_frame_new (_("Quotation"));
	gtk_widget_show (frame_quote);
	gtk_box_pack_start (GTK_BOX (vbox_compose), frame_quote, FALSE, FALSE, 0);
	gtk_frame_set_label_align (GTK_FRAME (frame_quote), 0.01, 0.5);

	vbox_quote = gtk_vbox_new (FALSE, 8);
	gtk_widget_show (vbox_quote);
	gtk_container_add (GTK_CONTAINER (frame_quote), vbox_quote);
	gtk_container_set_border_width (GTK_CONTAINER (vbox_quote), 8);

	hbox1 = gtk_hbox_new (FALSE, 8);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox_quote), hbox1, TRUE, TRUE, 0);

	label_quotemark = gtk_label_new (_("Quotation mark"));
	gtk_widget_show (label_quotemark);
	gtk_box_pack_start (GTK_BOX (hbox1), label_quotemark, FALSE, FALSE, 0);

	entry_quotemark = gtk_entry_new ();
	gtk_widget_show (entry_quotemark);
	gtk_box_pack_start (GTK_BOX (hbox1), entry_quotemark, FALSE, FALSE, 0);
	gtk_widget_set_usize (entry_quotemark, 64, -1);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox_quote), hbox2, TRUE, TRUE, 0);

	label_quotefmt = gtk_label_new (_("Quotation format:"));
	gtk_widget_show (label_quotefmt);
	gtk_box_pack_start (GTK_BOX (hbox2), label_quotefmt, FALSE, FALSE, 0);

	btn_quotedesc =
		gtk_button_new_with_label (_(" Description of symbols "));
	gtk_widget_show (btn_quotedesc);
	gtk_box_pack_end (GTK_BOX (hbox2), btn_quotedesc, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(btn_quotedesc), "clicked",
			   GTK_SIGNAL_FUNC(prefs_quote_description), NULL);

	scrolledwin_quotefmt = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (scrolledwin_quotefmt);
	gtk_box_pack_start (GTK_BOX (vbox_quote), scrolledwin_quotefmt, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy
		(GTK_SCROLLED_WINDOW (scrolledwin_quotefmt),
		 GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	text_quotefmt = gtk_text_new (NULL, NULL);
	gtk_widget_show (text_quotefmt);
	gtk_container_add(GTK_CONTAINER(scrolledwin_quotefmt), text_quotefmt);
	gtk_text_set_editable (GTK_TEXT (text_quotefmt), TRUE);
	gtk_widget_set_usize(text_quotefmt, -1, 60);

	checkbtn_autosig = gtk_check_button_new_with_label
		(_("Insert signature automatically"));
	gtk_widget_show (checkbtn_autosig);
	gtk_box_pack_start (GTK_BOX (vbox_compose), checkbtn_autosig,
			    FALSE, FALSE, 0);

	compose.entry_quotemark  = entry_quotemark;
	compose.text_quotefmt    = text_quotefmt;
	compose.checkbtn_autosig = checkbtn_autosig;
}

static void prefs_assort_create(void)
{
	GtkWidget *vbox1;
	GtkWidget *table1;
	GtkWidget *op_label;
	GtkWidget *op_combo;
	GtkWidget *op_entry;
	GtkWidget *hdr_label;
	GtkWidget *hdr_combo1;
	GtkWidget *hdr_combo2;
	GtkWidget *key_label;
	GtkWidget *key_entry1;
	GtkWidget *key_entry2;
	GtkWidget *pred_label;
	GtkWidget *pred_combo1;
	GtkWidget *pred_entry1;
	GtkWidget *pred_combo2;
	GtkWidget *pred_entry2;

	GtkWidget *hbox1;
	GtkWidget *vbox2;
	GtkWidget *reg_btn;
	GtkWidget *subst_btn;
	GtkWidget *del_btn;
	GtkWidget *arrow;

	GtkWidget *vbox3;
	GtkWidget *hbox2;
	GtkWidget *dest_label;
	GtkWidget *dest_entry;
	GtkWidget *hbox3;
	GtkWidget *destsel_btn;

	GtkWidget *vbox4;
	GtkWidget *regex_chkbtn;

	GtkWidget *hbox4;
	GtkWidget *cond_scrolledwin;
	GtkWidget *cond_clist;

	GtkWidget *vbox5;
	GtkWidget *up_btn;
	GtkWidget *down_btn;

	gchar *title[] = {_("Registered rules")};

	vbox1 = gtk_vbox_new (FALSE, VSPACING);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (dialog.notebook), vbox1);
	gtk_container_set_border_width (GTK_CONTAINER (vbox1), 16);

	table1 = gtk_table_new (3, 4, FALSE);
	gtk_widget_show (table1);
	gtk_box_pack_start (GTK_BOX (vbox1), table1, FALSE, FALSE, 0);
	gtk_table_set_row_spacings (GTK_TABLE (table1), 8);
	gtk_table_set_col_spacings (GTK_TABLE (table1), 8);

	op_label = gtk_label_new (_("Operator"));
	gtk_widget_show (op_label);
	gtk_table_attach (GTK_TABLE (table1), op_label, 0, 1, 0, 1,
			  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
			  0, 0, 0);
	gtk_misc_set_alignment (GTK_MISC (op_label), 0, 0.5);

	op_combo = gtk_combo_new ();
	gtk_widget_show (op_combo);
	gtk_table_attach (GTK_TABLE (table1), op_combo, 0, 1, 2, 3,
			  0, 0, 0, 0);
	gtk_widget_set_usize (op_combo, 52, -1);
	gtkut_combo_set_items (GTK_COMBO (op_combo), "and", "or", NULL);

	op_entry = GTK_COMBO (op_combo)->entry;
	gtk_entry_set_editable (GTK_ENTRY (op_entry), FALSE);

	hdr_label = gtk_label_new (_("Header"));
	gtk_widget_show (hdr_label);
	gtk_table_attach (GTK_TABLE (table1), hdr_label, 1, 2, 0, 1,
			  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
			  0, 0, 0);
	gtk_misc_set_alignment (GTK_MISC (hdr_label), 0, 0.5);

	hdr_combo1 = gtk_combo_new ();
	gtk_widget_show (hdr_combo1);
	gtk_table_attach (GTK_TABLE (table1), hdr_combo1, 1, 2, 1, 2,
			  0, 0, 0, 0);
	gtk_widget_set_usize (hdr_combo1, 96, -1);
	gtkut_combo_set_items (GTK_COMBO (hdr_combo1),
			       "Subject", "From", "To", "Sender", "X-ML-Name",
			       NULL);

	hdr_combo2 = gtk_combo_new ();
	gtk_widget_show (hdr_combo2);
	gtk_table_attach (GTK_TABLE (table1), hdr_combo2, 1, 2, 2, 3,
			  0, 0, 0, 0);
	gtk_widget_set_usize (hdr_combo2, 96, -1);
	gtkut_combo_set_items (GTK_COMBO (hdr_combo2),
			       _("(none)"), "Subject", "From", "To", "Sender",
			       "X-ML-Name", NULL);

	key_label = gtk_label_new (_("Keyword"));
	gtk_widget_show (key_label);
	gtk_table_attach (GTK_TABLE (table1), key_label, 2, 3, 0, 1,
			  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
			  0, 0, 0);
	gtk_misc_set_alignment (GTK_MISC (key_label), 0, 0.5);

	key_entry1 = gtk_entry_new ();
	gtk_widget_show (key_entry1);
	gtk_table_attach (GTK_TABLE (table1), key_entry1, 2, 3, 1, 2,
			  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
			  0, 0, 0);

	key_entry2 = gtk_entry_new ();
	gtk_widget_show (key_entry2);
	gtk_table_attach (GTK_TABLE (table1), key_entry2, 2, 3, 2, 3,
			  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
			  0, 0, 0);

	pred_label = gtk_label_new (_("Predicate"));
	gtk_widget_show (pred_label);
	gtk_table_attach (GTK_TABLE (table1), pred_label, 3, 4, 0, 1,
			  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
			  0, 0, 0);
	gtk_misc_set_alignment (GTK_MISC (pred_label), 0, 0.5);

	pred_combo1 = gtk_combo_new ();
	gtk_widget_show (pred_combo1);
	gtk_table_attach (GTK_TABLE (table1), pred_combo1, 3, 4, 1, 2,
			  0, 0, 0, 0);
	gtk_widget_set_usize (pred_combo1, 92, -1);
	gtkut_combo_set_items (GTK_COMBO (pred_combo1),
			       "contains", "not contain", NULL);

	pred_entry1 = GTK_COMBO (pred_combo1)->entry;
	gtk_entry_set_editable (GTK_ENTRY (pred_entry1), FALSE);

	pred_combo2 = gtk_combo_new ();
	gtk_widget_show (pred_combo2);
	gtk_table_attach (GTK_TABLE (table1), pred_combo2, 3, 4, 2, 3,
			  0, 0, 0, 0);
	gtk_widget_set_usize (pred_combo2, 92, -1);
	gtkut_combo_set_items (GTK_COMBO (pred_combo2),
			       "contains", "not contain", NULL);

	pred_entry2 = GTK_COMBO (pred_combo2)->entry;
	gtk_entry_set_editable (GTK_ENTRY (pred_entry2), FALSE);

	hbox1 = gtk_hbox_new (FALSE, 8);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 0);

	vbox2 = gtk_vbox_new (FALSE, 6);
	gtk_widget_show (vbox2);
	gtk_box_pack_start (GTK_BOX (hbox1), vbox2, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (vbox2), 4);

	reg_btn = gtk_button_new_with_label (_("Register"));
	gtk_widget_show (reg_btn);
	gtk_box_pack_start (GTK_BOX (vbox2), reg_btn, FALSE, FALSE, 0);
	gtk_signal_connect (GTK_OBJECT (reg_btn), "clicked",
			    GTK_SIGNAL_FUNC (prefs_assort_register_cb), NULL);

	subst_btn = gtk_button_new_with_label (_(" Substitute "));
	gtk_widget_show (subst_btn);
	gtk_box_pack_start (GTK_BOX (vbox2), subst_btn, FALSE, FALSE, 0);
	gtk_signal_connect (GTK_OBJECT (subst_btn), "clicked",
			    GTK_SIGNAL_FUNC (prefs_assort_substitute_cb),
			    NULL);

	del_btn = gtk_button_new_with_label (_("Delete"));
	gtk_widget_show (del_btn);
	gtk_box_pack_start (GTK_BOX (vbox2), del_btn, FALSE, FALSE, 0);
	gtk_signal_connect (GTK_OBJECT (del_btn), "clicked",
			    GTK_SIGNAL_FUNC (prefs_assort_delete_cb), NULL);

	arrow = gtk_arrow_new (GTK_ARROW_DOWN, GTK_SHADOW_OUT);
	gtk_widget_show (arrow);
	gtk_box_pack_start (GTK_BOX (vbox2), arrow, FALSE, FALSE, 0);
	gtk_widget_set_usize (arrow, -1, 16);

	vbox3 = gtk_vbox_new (FALSE, 8);
	gtk_widget_show (vbox3);
	gtk_box_pack_start (GTK_BOX (hbox1), vbox3, TRUE, TRUE, 0);

	hbox2 = gtk_hbox_new (FALSE, 8);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox3), hbox2, FALSE, TRUE, 0);

	dest_label = gtk_label_new (_("Destination"));
	gtk_widget_show (dest_label);
	gtk_box_pack_start (GTK_BOX (hbox2), dest_label, FALSE, FALSE, 0);

	dest_entry = gtk_entry_new ();
	gtk_widget_show (dest_entry);
	gtk_box_pack_start (GTK_BOX (hbox2), dest_entry, TRUE, TRUE, 0);
	gtk_entry_set_editable (GTK_ENTRY (dest_entry), FALSE);

	hbox3 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox3), hbox3, FALSE, FALSE, 0);

	destsel_btn = gtk_button_new_with_label (_(" Select... "));
	gtk_widget_show (destsel_btn);
	gtk_box_pack_end (GTK_BOX (hbox3), destsel_btn, FALSE, FALSE, 0);
	gtk_signal_connect (GTK_OBJECT (destsel_btn), "clicked",
			    GTK_SIGNAL_FUNC (prefs_assort_select_dest_cb),
			    NULL);

	vbox4 = gtk_vbox_new (FALSE, 4);
	gtk_widget_show (vbox4);
	gtk_box_pack_end (GTK_BOX (hbox1), vbox4, FALSE, FALSE, 0);

	regex_chkbtn = gtk_check_button_new_with_label (_("Use regex"));
	gtk_widget_show (regex_chkbtn);
	gtk_box_pack_start (GTK_BOX (vbox4), regex_chkbtn, FALSE, FALSE, 0);
	gtk_widget_set_sensitive(regex_chkbtn, FALSE);

	hbox4 = gtk_hbox_new (FALSE, 8);
	gtk_widget_show (hbox4);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox4, TRUE, TRUE, 0);

	cond_scrolledwin = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (cond_scrolledwin);
	gtk_box_pack_start (GTK_BOX (hbox4), cond_scrolledwin, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (cond_scrolledwin),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);

	cond_clist = gtk_clist_new_with_titles(1, title);
	gtk_widget_show (cond_clist);
	gtk_container_add (GTK_CONTAINER (cond_scrolledwin), cond_clist);
	gtk_clist_set_column_width (GTK_CLIST (cond_clist), 0, 80);
	gtk_clist_set_selection_mode (GTK_CLIST (cond_clist),
				      GTK_SELECTION_BROWSE);
	gtk_signal_connect (GTK_OBJECT (cond_clist), "select_row",
			    GTK_SIGNAL_FUNC (prefs_assort_select), NULL);

	vbox5 = gtk_vbox_new (FALSE, 8);
	gtk_widget_show (vbox5);
	gtk_box_pack_start (GTK_BOX (hbox4), vbox5, FALSE, FALSE, 0);
	gtk_widget_set_usize (vbox5, 38, -1);

	up_btn = gtk_button_new_with_label (_("Up"));
	gtk_widget_show (up_btn);
	gtk_box_pack_start (GTK_BOX (vbox5), up_btn, FALSE, FALSE, 0);
	gtk_signal_connect (GTK_OBJECT (up_btn), "clicked",
			    GTK_SIGNAL_FUNC (prefs_assort_up), NULL);

	down_btn = gtk_button_new_with_label (_("Down"));
	gtk_widget_show (down_btn);
	gtk_box_pack_start (GTK_BOX (vbox5), down_btn, FALSE, FALSE, 0);
	gtk_signal_connect (GTK_OBJECT (down_btn), "clicked",
			    GTK_SIGNAL_FUNC (prefs_assort_down), NULL);

	assort.hdr_combo1  = hdr_combo1;
	assort.hdr_combo2  = hdr_combo2;
	assort.hdr_entry1  = GTK_COMBO (hdr_combo1)->entry;
	assort.hdr_entry2  = GTK_COMBO (hdr_combo2)->entry;
	assort.key_entry1  = key_entry1;
	assort.key_entry2  = key_entry2;
	assort.pred_combo1 = pred_combo1;
	assort.pred_combo2 = pred_combo2;
	assort.pred_entry1 = pred_entry1;
	assort.pred_entry2 = pred_entry2;
	assort.op_combo    = op_combo;
	assort.op_entry    = op_entry;

	assort.dest_entry   = dest_entry;
	assort.regex_chkbtn = regex_chkbtn;

	assort.cond_clist   = cond_clist;
}

static void prefs_display_create(void)
{
	GtkWidget *entry_widfont;
	GtkWidget *entry_msgfont;
	GtkWidget *button_widfont;
	GtkWidget *button_msgfont;

	GtkWidget *chkbtn_enablecol;
	GtkWidget *button_quotecol;
	GtkWidget *button_urlcol;
	GtkWidget *button_sigcol;

	GtkWidget *chkbtn_transhdr;

	GtkWidget *vbox1;
	GtkWidget *frame_font;
	GtkWidget *table1;
	GtkWidget *label_widfont;
	GtkWidget *label_msgfont;
	GtkWidget *frame_color;
	GtkWidget *table2;
	GtkWidget *label1;
	GtkWidget *label2;
	GtkWidget *label3;

	vbox1 = gtk_vbox_new (FALSE, VSPACING);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (dialog.notebook), vbox1);
	gtk_container_set_border_width (GTK_CONTAINER (vbox1), 16);

	frame_font = gtk_frame_new (_("Font"));
	gtk_widget_show (frame_font);
	gtk_box_pack_start (GTK_BOX (vbox1), frame_font, FALSE, TRUE, 0);
	gtk_frame_set_label_align (GTK_FRAME (frame_font), 0.01, 0.5);

	table1 = gtk_table_new (2, 3, FALSE);
	gtk_widget_show (table1);
	gtk_container_add (GTK_CONTAINER (frame_font), table1);
	gtk_container_set_border_width (GTK_CONTAINER (table1), 8);
	gtk_table_set_row_spacings (GTK_TABLE (table1), 8);
	gtk_table_set_col_spacings (GTK_TABLE (table1), 8);

	entry_msgfont = gtk_entry_new ();
	gtk_widget_show (entry_msgfont);
	gtk_table_attach (GTK_TABLE (table1), entry_msgfont, 1, 2, 1, 2,
			  (GTK_EXPAND | GTK_FILL), 0, 0, 0);

	label_widfont = gtk_label_new (_("Widget"));
	gtk_widget_show (label_widfont);
	gtk_table_attach (GTK_TABLE (table1), label_widfont, 0, 1, 0, 1,
			  (GTK_FILL), (GTK_EXPAND | GTK_FILL), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label_widfont), 1, 0.5);

	label_msgfont = gtk_label_new (_("Message"));
	gtk_widget_show (label_msgfont);
	gtk_table_attach (GTK_TABLE (table1), label_msgfont, 0, 1, 1, 2,
			  (GTK_FILL), (GTK_EXPAND | GTK_FILL), 0, 0);

	button_widfont = gtk_button_new_with_label ("... ");
	gtk_widget_show (button_widfont);
	gtk_table_attach (GTK_TABLE (table1), button_widfont, 2, 3, 0, 1,
			  0, 0, 0, 0);

	button_msgfont = gtk_button_new_with_label ("... ");
	gtk_widget_show (button_msgfont);
	gtk_table_attach (GTK_TABLE (table1), button_msgfont, 2, 3, 1, 2,
			  0, 0, 0, 0);

	entry_widfont = gtk_entry_new ();
	gtk_widget_show (entry_widfont);
	gtk_table_attach (GTK_TABLE (table1), entry_widfont, 1, 2, 0, 1,
			  (GTK_EXPAND | GTK_FILL), 0, 0, 0);

	gtk_widget_set_sensitive(label_widfont, FALSE);
	gtk_widget_set_sensitive(entry_widfont, FALSE);
	gtk_widget_set_sensitive(button_widfont, FALSE);

	frame_color = gtk_frame_new (_("Color"));
	gtk_widget_show (frame_color);
	gtk_box_pack_start (GTK_BOX (vbox1), frame_color, FALSE, TRUE, 0);
	gtk_frame_set_label_align (GTK_FRAME (frame_color), 0.01, 0.5);

	table2 = gtk_table_new (4, 2, FALSE);
	gtk_widget_show (table2);
	gtk_container_add (GTK_CONTAINER (frame_color), table2);
	gtk_container_set_border_width (GTK_CONTAINER (table2), 8);
	gtk_table_set_row_spacings (GTK_TABLE (table2), 8);
	gtk_table_set_col_spacings (GTK_TABLE (table2), 8);

	chkbtn_enablecol = gtk_check_button_new_with_label
		(_("Enable coloration of message"));
	gtk_widget_show (chkbtn_enablecol);
	gtk_table_attach (GTK_TABLE (table2), chkbtn_enablecol, 0, 1, 0, 1,
			  (GTK_EXPAND | GTK_FILL), (GTK_FILL), 0, 0);

	label1 = gtk_label_new (_("Quotation (Ex. > foo bar )"));
	gtk_widget_show (label1);
	gtk_table_attach (GTK_TABLE (table2), label1, 0, 1, 1, 2,
			  (GTK_EXPAND | GTK_FILL), (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (label1), 0, 0.5);

	label2 = gtk_label_new (_("URI (Ex. http://www.somewhere.org/ )"));
	gtk_widget_show (label2);
	gtk_table_attach (GTK_TABLE (table2), label2, 0, 1, 2, 3,
			  (GTK_EXPAND | GTK_FILL), (GTK_FILL), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);

	label3 = gtk_label_new (_("Signature"));
	gtk_widget_show (label3);
	gtk_table_attach (GTK_TABLE (table2), label3, 0, 1, 3, 4,
			  (GTK_EXPAND | GTK_FILL), (GTK_FILL), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label3), 0, 0.5);

	button_quotecol = gtk_button_new_with_label (_(" Select... "));
	gtk_widget_show (button_quotecol);
	gtk_table_attach (GTK_TABLE (table2), button_quotecol, 1, 2, 1, 2,
			  0, 0, 0, 0);

	button_urlcol = gtk_button_new_with_label (_(" Select... "));
	gtk_widget_show (button_urlcol);
	gtk_table_attach (GTK_TABLE (table2), button_urlcol, 1, 2, 2, 3,
			  0, 0, 0, 0);

	button_sigcol = gtk_button_new_with_label (_(" Select... "));
	gtk_widget_show (button_sigcol);
	gtk_table_attach (GTK_TABLE (table2), button_sigcol, 1, 2, 3, 4,
			  0, 0, 0, 0);

	gtk_widget_set_sensitive(button_quotecol, FALSE);
	gtk_widget_set_sensitive(button_urlcol, FALSE);
	gtk_widget_set_sensitive(button_sigcol, FALSE);

	chkbtn_transhdr = gtk_check_button_new_with_label
		(_("Translate header name (such as `From:', `Subject:')"));
	gtk_widget_show (chkbtn_transhdr);
	gtk_box_pack_start (GTK_BOX (vbox1), chkbtn_transhdr, FALSE, TRUE, 0);

	SET_TOGGLE_SENSITIVITY(chkbtn_enablecol, label1);
	SET_TOGGLE_SENSITIVITY(chkbtn_enablecol, label2);
	SET_TOGGLE_SENSITIVITY(chkbtn_enablecol, label3);
	//SET_TOGGLE_SENSITIVITY(chkbtn_enablecol, button_quotecol);
	//SET_TOGGLE_SENSITIVITY(chkbtn_enablecol, button_urlcol);
	//SET_TOGGLE_SENSITIVITY(chkbtn_enablecol, button_sigcol);

	display.entry_widfont	= entry_widfont;
	display.entry_msgfont	= entry_msgfont;
	display.button_widfont	= button_widfont;
	display.button_msgfont	= button_msgfont;

	display.chkbtn_enablecol = chkbtn_enablecol;
	display.button_quotecol	 = button_quotecol;
	display.button_urlcol	 = button_urlcol;
	display.button_sigcol	 = button_sigcol;

	display.chkbtn_transhdr = chkbtn_transhdr;
}

static void prefs_interface_create(void)
{
	//GtkWidget *checkbtn_sepfolder;
	//GtkWidget *checkbtn_sepmsg;
	GtkWidget *checkbtn_emacs;
	GtkWidget *checkbtn_confonexit;

	GtkWidget *vbox1;
	//GtkWidget *frame_window;
	//GtkWidget *hbox1;

	vbox1 = gtk_vbox_new (FALSE, VSPACING);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (dialog.notebook), vbox1);
	gtk_container_set_border_width (GTK_CONTAINER (vbox1), 16);

#if 0
	frame_window = gtk_frame_new (_("Window layout"));
	gtk_widget_show (frame_window);
	gtk_box_pack_start (GTK_BOX (vbox1), frame_window, FALSE, FALSE, 0);
	gtk_frame_set_label_align (GTK_FRAME (frame_window), 0.01, 0.5);

	hbox1 = gtk_hbox_new (FALSE, 8);
	gtk_widget_show (hbox1);
	gtk_container_add (GTK_CONTAINER (frame_window), hbox1);
	gtk_container_set_border_width (GTK_CONTAINER (hbox1), 8);

	checkbtn_sepfolder =
		gtk_check_button_new_with_label (_("Separate folder list"));
	gtk_widget_show (checkbtn_sepfolder);
	gtk_box_pack_start (GTK_BOX (hbox1), checkbtn_sepfolder,
			    FALSE, FALSE, 0);

	checkbtn_sepmsg =
		gtk_check_button_new_with_label (_("Separate message view"));
	gtk_widget_show (checkbtn_sepmsg);
	gtk_box_pack_start (GTK_BOX (hbox1), checkbtn_sepmsg, FALSE, FALSE, 0);
#endif

	checkbtn_emacs = gtk_check_button_new_with_label
		(_("Emulate the behavior of Emacs-based mailer"));
	gtk_widget_show (checkbtn_emacs);
	gtk_box_pack_start (GTK_BOX (vbox1), checkbtn_emacs, FALSE, FALSE, 0);

	checkbtn_confonexit = gtk_check_button_new_with_label
		(_("Confirm on exit"));
	gtk_widget_show (checkbtn_confonexit);
	gtk_box_pack_start (GTK_BOX (vbox1), checkbtn_confonexit,
			    FALSE, FALSE, 0);

	//interface.checkbtn_sepfolder	= checkbtn_sepfolder;
	//interface.checkbtn_sepmsg	= checkbtn_sepmsg;
	interface.checkbtn_emacs	= checkbtn_emacs;
	interface.checkbtn_confonexit	= checkbtn_confonexit;
}

static void prefs_quote_description(void)
{
	if (!quote_desc_win)
		prefs_quote_description_create();
	gtk_widget_show(quote_desc_win);
}

static void prefs_quote_description_create(void)
{
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *label;
	/* GtkWidget *ok_btn; */

	quote_desc_win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(quote_desc_win),
			     _("Description of symbols"));
	gtk_container_set_border_width(GTK_CONTAINER(quote_desc_win), 8);
	gtk_signal_connect(GTK_OBJECT(quote_desc_win), "delete_event",
			   GTK_SIGNAL_FUNC(gtk_widget_hide_on_delete), NULL);

	vbox = gtk_vbox_new(FALSE, 8);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(quote_desc_win), vbox);

	hbox = gtk_hbox_new(FALSE, 4);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);

	label = gtk_label_new
		("%d:\n"
		 "%f:\n"
		 "%s:\n"
		 "%t:\n"
		 "%i:\n"
		 "%%:");
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);

	label = gtk_label_new
		(_("Date\n"
		   "from\n"
		   "Subject\n"
		   "To\n"
		   "Message-ID\n"
		   "%"));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);

#if 0
	ok_btn = gtk_button_new_with_label(_("OK"));
	gtk_widget_show(ok_btn);
	gtk_box_pack_end(GTK_BOX(vbox), ok_btn, FALSE, FALSE, 0);
	gtk_signal_connect_object(GTK_OBJECT(ok_btn), "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_hide_on_delete),
				  GTK_OBJECT(quote_desc_win));
#endif
}

/* assort functions */

static void prefs_assort_read_config(void)
{
	gchar *rcpath;
	FILE *fp;
	gchar buf[PREFSBUFSIZE];
	Filter *filter;

	debug_print(_("Reading assort configuration...\n"));

	rcpath = g_strconcat(g_get_home_dir(), G_DIR_SEPARATOR_S, RC_DIR,
			     G_DIR_SEPARATOR_S, ASSORT_RC, NULL);
	if ((fp = fopen(rcpath, "r")) == NULL) {
		fprintf(stderr, "%s: ", rcpath);
		perror("fopen");
		g_free(rcpath);
		return;
	}
	g_free(rcpath);

	/* remove all previous filter list */
	while (prefs_common.fltlist != NULL) {
		filter = (Filter *)prefs_common.fltlist->data;
		filter_free(filter);
		prefs_common.fltlist = g_slist_remove(prefs_common.fltlist,
						      filter);
	}

	while (fgets(buf, sizeof(buf), fp) != NULL) {
		g_strchomp(buf);
		filter = filter_read_str(buf);
		if (filter) {
			prefs_common.fltlist =
				g_slist_append(prefs_common.fltlist, filter);
		}
	}

	fclose(fp);
}

static void prefs_assort_write_config(void)
{
	gchar *rcpath;
	FILE *fp;
	GSList *cur;
	Filter *filter;
	gchar *fstr;

	debug_print(_("Writing assort configuration...\n"));

	rcpath = g_strconcat(g_get_home_dir(), G_DIR_SEPARATOR_S, RC_DIR,
			     G_DIR_SEPARATOR_S, ASSORT_RC, NULL);
	if ((fp = fopen(rcpath, "w")) == NULL) {
		fprintf(stderr, "%s: ", rcpath);
		perror("fopen");
		g_free(rcpath);
		return;
	}
	g_free(rcpath);

	for (cur = prefs_common.fltlist; cur != NULL; cur = cur->next) {
		filter = (Filter *)cur->data;

		fstr = filter_get_str(filter);
		fputs(fstr, fp);
		fputc('\n', fp);
		g_free(fstr);
	}

	fclose(fp);
}

static void prefs_assort_set_dialog(void)
{
	GtkCList *clist = GTK_CLIST(assort.cond_clist);
	GSList *cur;
	Filter *filter;
	gchar *cond_str[1];
	gint row;

	gtk_clist_freeze(clist);
	gtk_clist_clear(clist);

	cond_str[0] = _("(New)");
	row = gtk_clist_append(clist, cond_str);
	gtk_clist_set_row_data(clist, row, NULL);

	for (cur = prefs_common.fltlist; cur != NULL; cur = cur->next) {
		filter = (Filter *)cur->data;

		cond_str[0] = filter_get_str(filter);
		subst_char(cond_str[0], '\t', ':');
		row = gtk_clist_append(clist, cond_str);
		gtk_clist_set_row_data(clist, row, filter);

		g_free(cond_str[0]);
	}

	gtk_clist_thaw(clist);
}

static void prefs_assort_set_list(void)
{
	gint row = 1;
	Filter *filter;

	slist_remove_all(prefs_common.fltlist);
	prefs_common.fltlist = NULL;

	while ((filter = gtk_clist_get_row_data(GTK_CLIST(assort.cond_clist),
		row)) != NULL) {
		prefs_common.fltlist = g_slist_append(prefs_common.fltlist,
						      filter);
		row++;
	}
}

static gint prefs_assort_clist_set_row(gint row)
{
	GtkCList *clist = GTK_CLIST(assort.cond_clist);
	Filter *filter;
	gchar *entry_text;
	gchar *cond_str[1];

	g_return_val_if_fail(row != 0, -1);

	entry_text = gtk_entry_get_text(GTK_ENTRY(assort.dest_entry));
	if (entry_text[0] == '\0') {
		g_print("destination is not set\n");
		return -1;
	}
	entry_text = gtk_entry_get_text(GTK_ENTRY(assort.hdr_entry1));
	if (entry_text[0] == '\0') {
		g_print("header name is not set\n");
		return -1;
	}

	filter = g_new0(Filter, 1);

	filter->name1 = g_strdup(entry_text);

	entry_text = gtk_entry_get_text(GTK_ENTRY(assort.key_entry1));
	if (entry_text[0] != '\0')
		filter->body1 = g_strdup(entry_text);

	entry_text = gtk_entry_get_text(GTK_ENTRY(assort.hdr_entry2));
	if (entry_text[0] != '\0' && strcmp(entry_text, _("(none)")) != 0) {
		filter->name2 = g_strdup(entry_text);

		entry_text = gtk_entry_get_text(GTK_ENTRY(assort.key_entry2));
		if (entry_text[0] != '\0')
			filter->body2 = g_strdup(entry_text);
	}

	entry_text = gtk_entry_get_text(GTK_ENTRY(assort.op_entry));
	if (!strcmp(entry_text, "and"))
		filter->cond = FLT_AND;
	else
		filter->cond = FLT_OR;

	filter->case_sens = FALSE;

	entry_text = gtk_entry_get_text(GTK_ENTRY(assort.dest_entry));
	filter->dest = g_strdup(entry_text);

	cond_str[0] = filter_get_str(filter);
	subst_char(cond_str[0], '\t', ':');

	if (row < 0)
		row = gtk_clist_append(clist, cond_str);
	else {
		Filter *flt;

		gtk_clist_set_text(clist, row, 0, cond_str[0]);
		flt = gtk_clist_get_row_data(clist, row);
		if (flt)
			filter_free(flt);
	}

	gtk_clist_set_row_data(clist, row, filter);

	g_free(cond_str[0]);

	prefs_assort_set_list();

	return row;
}

static void prefs_assort_select_dest_cb(void)
{
	gchar *dest;

	dest = foldersel_folder_sel(NULL);
	if (!dest) return;

	gtk_entry_set_text(GTK_ENTRY(assort.dest_entry), dest);
}

static void prefs_assort_register_cb(void)
{
	prefs_assort_clist_set_row(-1);
}

static void prefs_assort_substitute_cb(void)
{
	GtkCList *clist = GTK_CLIST(assort.cond_clist);
	Filter *filter;
	gint row;

	if (!clist->selection) return;

	row = GPOINTER_TO_INT(clist->selection->data);
	if (row == 0) return;

	filter = gtk_clist_get_row_data(clist, row);
	if (!filter) return;

	prefs_assort_clist_set_row(row);
}

static void prefs_assort_delete_cb(void)
{
	GtkCList *clist = GTK_CLIST(assort.cond_clist);
	Filter *filter;
	gint row;

	if (!clist->selection) return;
	row = GPOINTER_TO_INT(clist->selection->data);
	if (row == 0) return;

	if (alertpanel(_("Delete rule"),
		       _("Do you really want to delete this rule?"),
		       _("Yes"), _("No"), NULL) == G_ALERTALTERNATE)
		return;

	filter = gtk_clist_get_row_data(clist, row);
	filter_free(filter);
	gtk_clist_remove(clist, row);
	prefs_common.fltlist = g_slist_remove(prefs_common.fltlist, filter);
}

static void prefs_assort_up(void)
{
	GtkCList *clist = GTK_CLIST(assort.cond_clist);
	gint row;

	if (!clist->selection) return;

	row = GPOINTER_TO_INT(clist->selection->data);
	if (row > 1) {
		gtk_clist_row_move(clist, row, row - 1);
		prefs_assort_set_list();
	}
}

static void prefs_assort_down(void)
{
	GtkCList *clist = GTK_CLIST(assort.cond_clist);
	gint row;

	if (!clist->selection) return;

	row = GPOINTER_TO_INT(clist->selection->data);
	if (row > 0 && row < GPOINTER_TO_INT(clist->row_list_end->data)) {
		gtk_clist_row_move(clist, row, row + 1);
		prefs_assort_set_list();
	}
}

#define ENTRY_SET_TEXT(entry, str) \
	gtk_entry_set_text(GTK_ENTRY(entry), str ? str : "")

static void prefs_assort_select(GtkCList *clist, gint row, gint column,
				GdkEvent *event)
{
	Filter *filter;
	Filter default_flt = {"Subject", NULL, _("(none)"), NULL, FLT_AND,
			      FALSE, NULL};

	filter = gtk_clist_get_row_data(clist, row);
	if (!filter)
		filter = &default_flt;

	ENTRY_SET_TEXT(assort.dest_entry, filter->dest);
	ENTRY_SET_TEXT(assort.hdr_entry1, filter->name1);
	ENTRY_SET_TEXT(assort.key_entry1, filter->body1);
	ENTRY_SET_TEXT(assort.hdr_entry2,
		       filter->name2 ? filter->name2 : _("(none)"));
	ENTRY_SET_TEXT(assort.key_entry2, filter->body2);
	gtk_entry_set_text(GTK_ENTRY(assort.op_entry),
			   filter->cond == FLT_OR ? "or" : "and");
}

static void prefs_common_key_pressed(GtkWidget *widget, GdkEventKey *event,
				     gpointer data)
{
	if (event && event->keyval == GDK_Escape)
		gtk_widget_hide(dialog.window);
}

static void prefs_common_ok(GtkButton *button)
{
	prefs_common_apply(button);
	gtk_widget_hide(dialog.window);
	if (quote_desc_win && GTK_WIDGET_VISIBLE(quote_desc_win))
		gtk_widget_hide(quote_desc_win);
}

static void prefs_common_apply(GtkButton *button)
{
	prefs_set_data_from_dialog(param);
	messageview_set_font();
	prefs_common_save_config();
	prefs_assort_write_config();
}
