#ifndef __PREFS_COMMON_H__
#define __PREFS_COMMON_H__

#include <glib.h>

#include "mainwindow.h"

typedef struct _PrefsCommon	PrefsCommon;

struct _PrefsCommon
{
	/* Compose */
	gchar *quotemark;
	gchar *quotefmt;
	gboolean auto_sig;

	/* Receive */
	gboolean use_extinc;
	gchar *extinc_path;
	gboolean inc_local;
	gchar *spool_path;
	gboolean autochk_newmail;
	gint autochk_itv;
	gboolean chk_on_startup;

	/* Send */
	gboolean use_extsend;
	gchar *extsend_path;
	gboolean savemsg;
	gboolean queue_msg;

	/* Filtering / Assort */
	GSList *fltlist;

	/* Display */
	gchar *widgetfont;
	gchar *messagefont;
	gboolean enable_color;
	gushort quote_col;
	gushort uri_col;
	gushort sig_col;
	ToolbarStyle toolbar_style;
	gboolean trans_hdr;

	gint folderview_x;
	gint folderview_y;
	gint folderview_width;
	gint folderview_height;
	gint mainview_x;
	gint mainview_y;
	gint mainview_width;
	gint mainview_height;

	/* Interface */
	gboolean sep_folder;
	gboolean sep_msg;
	gboolean emulate_emacs;
	gboolean confirm_on_exit;
};

extern PrefsCommon prefs_common;

void prefs_common_read_config(void);
void prefs_common_save_config(void);
void prefs_common_open(void);

#endif /* __PREFS_COMMON_H__ */
