#ifndef __PROCHEADER_H__
#define __PROCHEADER_H__

#include <glib.h>
#include <stdio.h>
#include <time.h>

#include "procmsg.h"

typedef struct _HeaderEntry	HeaderEntry;
typedef struct _Header		Header;

struct _HeaderEntry
{
	gchar	 *name;
	gchar	 *body;
	gboolean  unfold;
};

struct _Header
{
	gchar *name;
	gchar *body;
};

gint procheader_get_one_field		(gchar		*buf,
					 gint		 len,
					 FILE		*fp,
					 HeaderEntry	 hentry[]);
gchar *procheader_get_unfolded_line	(gchar		*buf,
					 gint		 len,
					 FILE		*fp);

GSList *procheader_get_header_list	(const gchar	*file);
void procheader_header_list_destroy	(GSList		*hlist);
void procheader_get_header_fields	(FILE		*fp,
					 HeaderEntry	 hentry[]);
void procheader_parse			(MsgInfo	*msginfo,
					 const gchar	*file);

gchar *procheader_get_fromname		(const gchar	*str);

time_t procheader_date_parse		(gchar		*dest,
					 const gchar	*src,
					 gint		 len);
void procheader_date_get_localtime	(gchar		*dest,
					 gint		 len,
					 const time_t	 timer);

#endif /* __PROCHEADER_H__ */
