#ifndef __PROCMSG_H__
#define __PROCMSG_H__

#include <glib.h>
#include <stdio.h>
#include <time.h>
#include <sys/types.h>
#include <string.h>

typedef enum
{
	M_MAIL,
	M_NEWS
} MsgType;

typedef enum
{
	MSG_NEW		= 1 << 0,
	MSG_UNREAD	= 1 << 1,
	MSG_MARKED	= 1 << 2,
	MSG_DELETED	= 1 << 3,
	MSG_IMPORTANT	= 1 << 4,
	MSG_MOVE	= 1 << 5,
	MSG_COPY	= 1 << 6,

	MSG_NEWS	= 1 << 30,
	MSG_CACHED	= 1 << 31
} MsgFlags;

#define MSG_SET_FLAGS(msg, flags)	{ (msg) |= (flags); }
#define MSG_UNSET_FLAGS(msg, flags)	{ (msg) &= ~(flags); }
#define MSG_IS_NEW(msg)			((msg & MSG_NEW) != 0)
#define MSG_IS_UNREAD(msg)		((msg & MSG_UNREAD) != 0)
#define MSG_IS_MARKED(msg)		((msg & MSG_MARKED) != 0)
#define MSG_IS_DELETED(msg)		((msg & MSG_DELETED) != 0)
#define MSG_IS_IMPORTANT(msg)		((msg & MSG_IMPORTANT) != 0)
#define MSG_IS_MOVE(msg)		((msg & MSG_MOVE) != 0)
#define MSG_IS_COPY(msg)		((msg & MSG_COPY) != 0)
#define MSG_IS_NEWS(msg)		((msg & MSG_NEWS) != 0)
#define MSG_IS_CACHED(msg)		((msg & MSG_CACHED) != 0)

#define READ_CACHE_DATA_INT(n, fp) \
{ \
	if (fread(&n, sizeof(n), 1, fp) != 1) { \
		g_print(_("Cache data is corrupted\n")); \
		procmsg_msginfo_free(msginfo); \
		break; \
	} \
}

#define READ_CACHE_DATA(data, fp) \
{ \
	if (fread(&len, sizeof(len), 1, fp) == 1 && len < BUFFSIZE) { \
		if (len > 0) \
			if (fread(buf, len, 1, fp) == 1) { \
				buf[len] = '\0'; \
				data = g_strdup(buf); \
			} \
	} else { \
		g_print(_("Cache data is corrupted\n")); \
		procmsg_msginfo_free(msginfo); \
		break; \
	} \
}

#define WRITE_CACHE_DATA_INT(n, fp) \
	fwrite(&n, sizeof(n), 1, fp)

#define WRITE_CACHE_DATA(data, fp) \
{ \
	gint len; \
 \
	if (data == NULL || (len = strlen(data)) == 0) { \
		len = 0; \
		WRITE_CACHE_DATA_INT(len, fp); \
	} else { \
		len = strlen(data); \
		WRITE_CACHE_DATA_INT(len, fp); \
		fwrite(data, len, 1, fp); \
	} \
}

typedef struct _MsgInfo		MsgInfo;

struct _MsgInfo
{
	guint  msgnum;
	off_t  size;
	time_t mtime;
	time_t date_t;
	MsgFlags flags;

	gchar *folder;
	gchar *to_folder;
	gchar *fromname;

	gchar *date;
	gchar *from;
	gchar *to;
	gchar *newsgroups;
	gchar *subject;
	gchar *msgid;
	gchar *inreplyto;
};

GSList *procmsg_get_msgs		(const gchar		*folder,
					 gboolean		 use_cache);
GHashTable *procmsg_msg_hash_table_create
					(GSList			*mlist);
void procmsg_msg_hash_table_append	(GHashTable		*msg_table,
					 GSList			*mlist);
GSList *procmsg_read_cache		(const gchar		*folder,
					 MsgType		 type);
void	procmsg_set_flags		(GSList			*mlist,
					 const gchar		*folder,
					 MsgType		 type);
gint	procmsg_get_last_num_in_cache	(GSList			*mlist);
void	procmsg_write_cache		(MsgInfo		*msginfo,
					 FILE			*fp);
void	procmsg_write_flags		(MsgInfo		*msginfo,
					 FILE			*fp);
void	procmsg_get_mark_sum		(const gchar		*folder,
					 gint			*new,
					 gint			*unread,
					 gint			*total);
FILE   *procmsg_open_mark_file		(const gchar		*folder,
					 gboolean		 append);
gint	procmsg_get_last_message_number	(const gchar		*dir);
gint	procmsg_copy_message		(const gchar		*destdir,
					 const gchar		*src);
void	procmsg_move_messages		(const gchar		*from,
					 GSList			*mlist);
void	procmsg_move_messages_with_dest	(const gchar		*to,
					 const gchar		*from,
					 GSList			*mlist);
void	procmsg_clean_trash		(void);
void	procmsg_msginfo_set		(MsgInfo		*msginfo,
					 const gchar		*msgnum,
					 const gchar		*folder,
					 MsgFlags		 default_flag);
void	procmsg_msginfo_free		(MsgInfo		*msginfo);

#endif /* __PROCMSG_H__ */
