/* progress.c */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <glib.h>
#include <gtk/gtkwindow.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkprogressbar.h>
#include <gtk/gtkbutton.h>

#include "intl.h"
#include "progress.h"
#include "gtkutils.h"
#include "utils.h"

Progress *progress_create(void)
{
	Progress *progress;
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *cancel_btn;
	GtkWidget *cancel_area;
	GtkWidget *progressbar;

	debug_print(_("Creating progress dialog...\n"));
	progress = g_new0(Progress, 1);

	window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_widget_set_usize(window, 400, -1);
	gtk_container_set_border_width(GTK_CONTAINER(window), 8);
	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
	gtk_window_set_modal(GTK_WINDOW(window), TRUE);
	gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);

	vbox = gtk_vbox_new(FALSE, 8);
	gtk_container_add(GTK_CONTAINER(window), vbox);
	gtk_widget_show(vbox);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 8);
	gtk_widget_show(hbox);

	label = gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 8);
	gtk_widget_show(label);

	gtkut_button_set_create(&cancel_area, &cancel_btn, _("Cancel"),
				NULL, NULL, NULL, NULL);
	gtk_box_pack_end(GTK_BOX(vbox), cancel_area, FALSE, FALSE, 0);
	gtk_widget_grab_default(cancel_btn);
	gtk_widget_show_all(cancel_area);

	progressbar = gtk_progress_bar_new();
	gtk_box_pack_end(GTK_BOX(vbox), progressbar, FALSE, FALSE, 0);
	gtk_widget_show(progressbar);

	progress->window      = window;
	progress->label       = label;
	progress->cancel_btn  = cancel_btn;
	progress->progressbar = progressbar;

	return progress;
}

void progress_set_label(Progress *progress, gchar *str)
{
	gtk_label_set_text(GTK_LABEL(progress->label), str);
}

void progress_set_value(Progress *progress, gfloat value)
{
	gtk_progress_set_value(GTK_PROGRESS(progress->progressbar), value);
}

void progress_set_percentage(Progress *progress, gfloat percentage)
{
	gtk_progress_set_percentage(GTK_PROGRESS(progress->progressbar),
				    percentage);
}

void progress_destroy(Progress *progress)
{
	gtk_widget_destroy(progress->window);
	g_free(progress);
}
