/* recv.c */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <glib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "intl.h"
#include "recv.h"
#include "socket.h"

#define BUFFSIZE	8192

gint recv_write_to_file(gint sock, const gchar *filename)
{
	FILE *fp;

	g_return_val_if_fail(filename != NULL, -1);

	if ((fp = fopen(filename, "w")) == NULL) {
		fprintf(stderr, "%s: ", filename);
		perror("fopen");
		recv_write(sock, NULL);
		return -1;
	}

	if (chmod(filename, S_IRUSR|S_IWUSR) < 0) {
		fprintf(stderr, "%s: ", filename);
		perror("chmod");
	}

	if (recv_write(sock, fp) < 0) {
		fclose(fp);
		unlink(filename);
		return -1;
	}

	fclose(fp);
	return 0;
}

gint recv_write(gint sock, FILE *fp)
{
	gchar buf[BUFFSIZE];
	gint len;

	for (;;) {
		if (sock_read(sock, buf, sizeof(buf)) < 0) {
			g_warning(_("error occured while retrieving data.\n"));
			return -1;
		}

		len = strlen(buf);
		if (len > 1 && buf[0] == '.' && buf[1] == '\r') break;

		if (len > 1 && buf[len - 1] == '\n' && buf[len - 2] == '\r') {
			buf[len - 2] = '\n';
			buf[len - 1] = '\0';
		}

		if (buf[0] == '.' && buf[1] == '.')
			memmove(buf, buf + 1, strlen(buf));

		if (!strncmp(buf, ">From ", 6))
			memmove(buf, buf + 1, strlen(buf));

		if (fp && fputs(buf, fp) == EOF) {
			perror("fputs");
			fp = NULL;
		}
	}

	return 0;
}
