#ifndef __SUMMARY_H__
#define __SUMMARY_H__

#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtkitemfactory.h>
#include <gtk/gtkctree.h>

typedef struct _SummaryView	SummaryView;

#include "mainwindow.h"
#include "folderview.h"
#include "headerview.h"
#include "messageview.h"
#include "headerwindow.h"
#include "news.h"

typedef enum
{
	SORT_BY_NUMBER,
	SORT_BY_DATE,
	SORT_BY_FROM,
	SORT_BY_SUBJECT
} SummarySortType;

typedef enum
{
	SUMMARY_MAIL,
	SUMMARY_NEWS
} SummaryMode;

struct _SummaryView
{
	GtkWidget *vbox;
	GtkWidget *scrolledwin;
	GtkWidget *ctree;
	GtkWidget *hbox;
	GtkWidget *statlabel_folder;
	GtkWidget *statlabel_select;
	GtkWidget *statlabel_msgs;
	GtkWidget *toggle_eventbox;
	GtkWidget *toggle_arrow;
	GtkWidget *popupmenu;

	GtkItemFactory *popupfactory;

	GtkWidget *window;

	GtkCTreeNode *selected;
	GtkCTreeNode *displayed;

	gboolean msg_is_toggled_on;
	gboolean display_msg;

	GdkColor color_marked;
	GdkColor color_dim;
	GdkColor color_normal;

	MainWindow   *mainwin;
	FolderView   *folderview;
	HeaderView   *headerview;
	MessageView  *messageview;
	HeaderWindow *headerwin;

	SummaryMode mode;

	gchar *cur_folder;

	NNTPSession *news_session;

	/* current message status */
	gint   newmsgs;
	gint   unread;
	gint   messages;
	off_t  total_size;
	gint   deleted;
	gint   moved;

/*
private:
*/
	/* table for looking up message-id */
	GHashTable *msgid_table;

	/* list for moving/deleting messages */
	GSList *mlist;
	/* table for updating folder tree */
	GHashTable *folder_table;
};

SummaryView	*summary_create(void);

void summary_init		  (SummaryView		*summaryview);
void summary_show		  (SummaryView		*summaryview,
				   FolderInfo		*finfo,
				   gboolean		 update_cache);
void summary_clear_list		  (SummaryView		*summaryview);
void summary_clear_all		  (SummaryView		*summaryview);
void summary_thread_build	  (SummaryView		*summaryview);
void summary_unthread		  (SummaryView		*summaryview);
void summary_assort		  (SummaryView		*summaryview);
void summary_sort		  (SummaryView		*summaryview,
				   SummarySortType	 type);
void summary_delete_duplicated	  (SummaryView		*summaryview);
void summary_execute		  (SummaryView		*summaryview);
void summary_attract_by_subject	  (SummaryView		*summaryview);
gint summary_write_cache	  (SummaryView		*summaryview);
void summary_pass_key_press_event (SummaryView		*summaryview,
				   GdkEventKey		*event);

#endif /* __SUMMARY_H__ */
