#ifndef __UTILS_H__
#define __UTILS_H__

#include <glib.h>
#include <wchar.h>
#include <unistd.h>
#include <sys/types.h>

#define CHDIR_RETURN_IF_FAIL(dir) \
{ \
	if (change_dir(dir) < 0) return; \
}

#define CHDIR_RETURN_VAL_IF_FAIL(dir, val) \
{ \
	if (change_dir(dir) < 0) return val; \
}

void list_remove_all(GList *list);
void slist_remove_all(GSList *list);

void conv_jistoeuc(gchar *outbuf, gint outlen, const gchar *inbuf);
void conv_euctojis(gchar *outbuf, gint outlen, const gchar *inbuf);
void conv_anytoeuc(gchar *outbuf, gint outlen, const gchar *inbuf);
void conv_anytojis(gchar *outbuf, gint outlen, const gchar *inbuf);
void conv_unreadable(gchar *str);

gint to_number(const gchar *nstr);
gchar *itos(gint n);
gchar *to_human_readable(off_t size);

gint strcmp2(const gchar *s1, const gchar *s2);
gint path_cmp(const gchar *s1, const gchar *s2);
gchar *strretchomp(gchar *str);
gchar *strcasestr(const gchar *haystack, const gchar *needle);

/* wide-character functions */
wchar_t *wcsdup(const wchar_t *s);
wchar_t *wcsndup(const wchar_t *s, size_t n);
wchar_t *strdup_mbstowcs(const gchar *s);
gchar *strdup_wcstombs(const wchar_t *s);
gint wcsncasecmp(const wchar_t *s1, const wchar_t *s2, size_t n);
wchar_t *wcscasestr(const wchar_t *haystack, const wchar_t *needle);
gboolean is_next_mbs(const wchar_t *s);
wchar_t *find_wspace(const wchar_t *s);

/* functions for header-parsing */
gint subject_compare(const gchar *s1, const gchar *s2);
void trim_subject(gchar *str);
void eliminate_parenthesis(gchar *str, gchar op, gchar cl);
void extract_parenthesis(gchar *str, gchar op, gchar cl);
void eliminate_quote(gchar *str, gchar quote_chr);
void extract_quote(gchar *str, gchar quote_chr);
void remove_return(gchar *str);
void remove_space(gchar *str);
void subst_char(gchar *str, gchar orig, gchar subst);
gboolean is_header_line(const gchar *str);

/* return static strings */
gchar *get_rc_dir(void);
gchar *get_news_cache_dir(void);
gchar *get_domain_name(void);

/* file / directory handling */
off_t get_file_size(const gchar *file);
gboolean is_file_exist(const gchar *file);
gboolean is_dir_exist(const gchar *dir);
gint change_dir(const gchar *dir);
gint remove_dir_recursive(const gchar *dir);
gint copy_file(const gchar *src, const gchar *dest);

void debug_print(const gchar *format, ...);
void log_print(const gchar *format, ...);

#endif /* __UTILS_H__ */
